/*
 *  libgfx2 - FreeBASIC's alternative gfx library
 *	Copyright (C) 2005 Angelo Mottola (a.mottola@libero.it)
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * lzw_enc.c -- tiny LZW codec
 *          Based on code by Mark Nelson, Dr. Dobb's Journal October, 1989
 *
 * chng: mar/2005 written [lillo]
 *
 */

#include "fb_gfx.h"
#include "fb_gfx_lzw.h"


/*:::::*/
static LZW_ENTRY *find_match(unsigned short prefix, unsigned char value)
{
	unsigned short index, offset = 1;

	index = ((unsigned short)value << 4) ^ prefix;
	if (index)
		offset = TABLE_SIZE - index;
	while (1) {
		if ((fb_lzw_entry[index].code == -1) ||
		    ((fb_lzw_entry[index].prefix == prefix) && (fb_lzw_entry[index].value == value)))
			return &fb_lzw_entry[index];
		index = (index + offset) % TABLE_SIZE;
	}
}

/*:::::*/
FBCALL int fb_hEncode(const unsigned char *in_buffer, int in_size, unsigned char *out_buffer, int *out_size)
{
	LZW_ENTRY *e;
	unsigned short string_code, next_code = 256;
	unsigned char bit = 0;
	int size;

	size = 0;
	fb_hMemSet(fb_lzw_entry, -1, sizeof(fb_lzw_entry));
	string_code = *in_buffer++;
	in_size--;
	while (in_size) {
		e = find_match(string_code, *in_buffer);
		if (e->code != -1)
			string_code = (unsigned short)e->code;
		else {
			if (next_code < MAX_CODE) {
				e->code = next_code++;
				e->prefix = string_code;
				e->value = *in_buffer;
			}
			OUTPUT_CODE(string_code);
			string_code = *in_buffer;
		}
		in_buffer++;
		in_size--;
	}
	OUTPUT_CODE(string_code);
	OUTPUT_CODE(MAX_CODE);
	if (bit)
		size++;
	*out_size = size;
	return 0;
}
