/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id: PfmExtension.java 3523 2007-10-16 11:03:09Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */

package org.jfree.fonts.pfm;

import java.io.IOException;

import org.jfree.fonts.LEByteAccessUtilities;

/**
 * This table contains offsets to other tables. It directly follows the header.
 *
 * @author Thomas Morgner
 */
public class PfmExtension
{
  private int extMetricsOffset;
  private int extentTable;
  private int originTable;
  private int pairKernTable;
  private int trackKernTable;
  private int driverInfo;
  public static final int LENGTH = 30;

  public PfmExtension(final byte[] data) throws IOException
  {
    if (LEByteAccessUtilities.readShort(data, 0) != 30)
    {
      throw new IOException ("Extended-Header must be 30 bytes long.");
    }
    extMetricsOffset = LEByteAccessUtilities.readLong(data, 2);
    extentTable = LEByteAccessUtilities.readLong(data, 6);
    originTable = LEByteAccessUtilities.readLong(data, 10);
    pairKernTable = LEByteAccessUtilities.readLong(data, 14);
    trackKernTable = LEByteAccessUtilities.readLong(data, 18);

    // driver info is a pointer to the full-qualified font name. Unlike Adobes description, this is *not* part
    // of the postscript information section (which is no three-entry-section anyway.)
    driverInfo = LEByteAccessUtilities.readLong(data, 22);
    // reserved 4 bytes follow
  }

  public int getExtMetricsOffset()
  {
    return extMetricsOffset;
  }

  public int getExtentTable()
  {
    return extentTable;
  }

  public int getOriginTable()
  {
    return originTable;
  }

  public int getPairKernTable()
  {
    return pairKernTable;
  }

  public int getTrackKernTable()
  {
    return trackKernTable;
  }

  public int getDriverInfo()
  {
    return driverInfo;
  }
}
