/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id: AfmDirectionSection.java 3523 2007-10-16 11:03:09Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */

package org.jfree.fonts.afm;

import java.io.IOException;

/**
 * Creation-Date: 22.07.2007, 15:41:29
 *
 * @author Thomas Morgner
 */
public class AfmDirectionSection
{
  private static final String START_LINE = "StartDirection ";
  private static final String UNDERLINE_POSITION = "UnderlinePosition ";
  private static final String UNDERLINE_THICKNESS = "UnderlineThickness ";
  private static final String ITALIC_ANGLE = "ItalicAngle ";
  private static final String CHARWIDTH = "CharWidth ";
  private static final String IS_FIXED_PITCH = "IsFixedPitch ";

  private double underlinePosition;
  private double underlineThickness;
  private double italicAngle;
  private double[] charWidth;
  private boolean fixedPitch;

  public AfmDirectionSection() throws IOException
  {
  }

  public void add(final String line) throws IOException
  {
    if (line.startsWith(UNDERLINE_POSITION))
    {
      underlinePosition = AfmParseUtilities.parseDouble(UNDERLINE_POSITION, line);
    }
    else if (line.startsWith(UNDERLINE_THICKNESS))
    {
      underlineThickness = AfmParseUtilities.parseDouble(UNDERLINE_THICKNESS, line);
    }
    else if (line.startsWith(ITALIC_ANGLE))
    {
      italicAngle = AfmParseUtilities.parseDouble(ITALIC_ANGLE, line);
    }
    else if (line.startsWith(CHARWIDTH))
    {
      charWidth = AfmParseUtilities.parseDoubleArray(line, 2);
    }
    else if (line.startsWith(IS_FIXED_PITCH))
    {
      final String boolText = line.substring(IS_FIXED_PITCH.length());
      fixedPitch = "true".equalsIgnoreCase(boolText);
    }
  }

  public double getUnderlinePosition()
  {
    return underlinePosition;
  }

  public double getUnderlineThickness()
  {
    return underlineThickness;
  }

  public double getItalicAngle()
  {
    return italicAngle;
  }

  public double[] getCharWidth()
  {
    return charWidth;
  }

  public boolean isFixedPitch()
  {
    return fixedPitch;
  }
}
