/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "flux.h"
#include <stdlib.h>
#include <string.h>

/* Workaround for obsolete OS implementations */

#ifndef LOG_AUTHPRIV
#  ifdef LOG_AUTH
#   define LOG_AUTHPRIV LOG_AUTH
# else
#  define LOG_AUTHPRIV LOG_USER
# endif
#endif

struct _log_opt _log_opt;
int _log_opt_initialized = 0;


int log_init(const char *service_name, unsigned short type, unsigned long options,
             int level_def)
{
  memset(&_log_opt, 0, sizeof(_log_opt));

  if (service_name) _log_opt.service_name = strdup(service_name);

  if (options & LOG_TO_SYSLOG && service_name)
  {
    openlog(service_name, LOG_NDELAY | LOG_CONS |
            (options & LOG_WITH_PID ? LOG_PID : 0),
            (type == LOG_TYPE_GENERIC)  ? LOG_USER :
            (type == LOG_TYPE_DAEMON)   ? LOG_DAEMON :
            (type == LOG_TYPE_SECURITY) ? LOG_AUTHPRIV : LOG_USER);

    _log_opt.to_syslog = 1;
  }

  if (options & LOG_WITH_PID) _log_opt.with_pid = 1;
  if ((options & LOG_WITH_NAME) && service_name) _log_opt.with_name = 1;
  if (options & LOG_TO_STDERR) _log_opt.to_stderr = 1;
  if (options & LOG_TO_STDOUT) _log_opt.to_stdout = 1;

  _log_opt.level = level_def;
  _log_opt_initialized = 1;
  
  return(1);
}


void log_level_set(int level)
{
  _log_opt.level = level;
}


unsigned long log_opt_get()
{
  unsigned long r;
  
  r = 0;
  if (_log_opt.with_pid) r |= LOG_WITH_PID;
  if (_log_opt.with_name) r |= LOG_WITH_NAME;
  if (_log_opt.to_syslog) r |= LOG_TO_SYSLOG;
  if (_log_opt.to_stderr) r |= LOG_TO_STDERR;
  if (_log_opt.to_stdout) r |= LOG_TO_STDOUT;

  return(r);
}


int log_set_cb(int (*func)(char *service, unsigned short type, int level,
                           unsigned long options))
{

  
  return(0);
}
