/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#ifndef _FSTRING_H
#define _FSTRING_H 1

#ifdef LIBFLUX_BUILD
# include "types.h"
#else
# include <flux/types.h>
#endif

#ifndef _STDIO_H
#  include <stdio.h>
#endif
#ifndef _STDARG_H
# include <stdarg.h>
#endif

#if defined(LIBFLUX_BUILD)
# if !defined(HAVE_ASPRINTF)
int asprintf(char **str, const char *format, ...);
# endif
#elif !defined(__USE_GNU)
int asprintf(char **str, const char *format, ...);
#endif

#if defined(LIBFLUX_BUILD)
# if !defined(HAVE_STRNDUP)
char *strndup(char *str, unsigned int len);
# endif
#elif !defined(__USE_GNU)
char *strndup(char *str, unsigned int len);
#endif

#if defined(LIBFLUX_BUILD)
# if !defined(HAVE_VASPRINTF)
int vasprintf(char **str, const char *format, va_list args);
# endif
#elif !defined(__USE_GNU)
int vasprintf(char **str, const char *format, va_list args);
#endif

int file_line_skip(FILE *in);
char *afgets(FILE *in, int len_max);

int strarr_num(char **str_list);
int strarr_find(char *find_str, char **strlist, int num_strs);
char **strarr_make_split(const char *path, const char delim);
void strarr_free(char **strarr);
unsigned int strchrnum(const char *str, char c);
char *strdcat(char *head, char *tail);

int strrcmp(char *container_str, char *tail_str);
void strtrim(char *str);
int strwrapcat(char *dest_str, char *src_str, int linelen, int maxlen);

int memcasecmp(byte *p0, byte *p1, u32 len);
size_t memspn(void *s, unsigned int len, const char *accept);
size_t memcspn(void *s, unsigned int len, const char *reject);
void *memrchr(const void *s, int c, size_t n);

#endif
