/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#ifndef CGI_H
#define CGI_H

#include <stdio.h>

#ifdef LIBFLUX_BUILD
# include "tt.h"
#else
# include <flux/tt.h>
#endif

/* cgi.c */
int cgi_post_item_next(FILE *in_fhd, char *var, char *val, unsigned int maxlen);
char *cgi_get_item_next(char *walk_str, char **item_str, char **data_str);
char *cgi_get_item(char *query_str, char *item_str);
/* cgi-ttree.c */
TT *cgi_args_get_to_ttree(char *args);
TT *cgi_args_post_to_ttree(FILE *in);

#endif /* CGI_H */
