/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

/**
 * Describes a re-useable structure for namespaces.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class NamespaceImpl
	implements Namespace
{

	private String namespaceURI;
	private String prefix;
	private String localName;
	private String name;

	/**
	 * Constructs a new <code>NamespaceImpl</code> with no parameters.
	 */
	public NamespaceImpl() {
		this(null, null, null, null);
	}

	/**
	 * Constructs a new <code>NamespaceImpl</code>
	 * with all required parameters.  These parameters
	 * may be <code>null</code>.
	 * Note that the values are not checked for correctness.
	 */
	public NamespaceImpl(String namespaceURI, String prefix, String localName, String name) {
		this.namespaceURI = namespaceURI;
		this.prefix = prefix;
		this.localName = localName;
		this.name = name;
	}

	/**
	 * Returns the namespace URI or <code>null</code> if this name
	 * belongs to the default namespace.
	 */
	public String getNamespaceURI() {
		return namespaceURI;
	}

	/**
	 * Sets the namespace URI.
	 */
	public void setNamespaceURI(String namespaceURI) {
		this.namespaceURI = namespaceURI;
	}

	/**
	 * Returns the prefix in use.
	 */
	public String getPrefix() {
		return prefix;
	}

	/**
	 * Sets the prefix to use.
	 */
	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	/**
	 * Returns the local name, without the prefix.
	 */
	public String getLocalName() {
		return localName;
	}

	/**
	 * Sets the local name to use.
	 */
	public void setLocalName(String localName) {
		this.localName = localName;
	}

	/**
	 * Returns the full name, including the colon.
	 */
	public String getName() {
		if (name == null)
			if (prefix != null && localName != null)
				name = prefix + ':' + localName;
		return name;
	}

	/**
	 * Sets the full name to use.
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Clears and sets all fields to null.
	 * @see #isClear
	 */
	public void clear() {
		this.namespaceURI = null;
		this.prefix = null;
		this.localName = null;
		this.name = null;
	}

	/**
	 * Returns true if no data has been stored within this
	 * namespace object, specifically if all fields are <code>null</code>.
	 *
	 * @see #clear
	 */
	public boolean isClear() {
		return this.namespaceURI == null &&
			this.prefix == null &&
			this.localName == null &&
			this.name == null;
	}

	/**
	 * Returns <code>true</code> if the namespace fields
	 * <code>prefix</code> and <code>localName</code> are set.
	 * Returns <code>false</code> if the name defined has no
	 * namespace.
	 */
	public boolean hasNamespace() {
		return prefix != null || localName != null;
	}

	public String toString() {
		return "NamespaceImpl prefix=" + prefix + 
			" name=" + name + 
			" localName=" + localName +
			" namespaceURI=" + namespaceURI;
	}

}
