/* 
 * $Id: ctkwindow.h,v 1.14 2000/07/21 17:59:05 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKWINDOW_H__
#define __CTKWINDOW_H__

/* Window Structure and Attributes */

#define WINMASK_MOVABLE		2
#define WINMASK_RESIZABLE	4
#define WINMASK_CLOSABLE	8
#define WINMASK_AUTOSHRINK	16
#define WINMASK_AUTOCENTER	32

struct CtkWindow_S 
{
      CtkBin bin;
      
      gchar*   title;
      gboolean shadow;
      gint     OPTIONS_MASK;
      
      gboolean resize_flag;
      gboolean close_flag;
      gboolean move_flag;
      
      CtkWidget* focus_widget;

      gboolean modal;
      CtkWindowPosition position;
};

typedef struct CtkWindow_S CtkWindow;

#define CTK_WINDOW(obj)	CTK_CHECK_CAST((obj),CtkWindow,CtkTypeWindow)

CtkWidget *ctk_window_new(CtkWindowType type);
void ctk_window_set_title(CtkWindow *window, const gchar *title);

void ctk_window_set_modal(CtkWindow *window, gboolean modal);
void ctk_window_set_position(CtkWindow *window, CtkWindowPosition position);
void ctk_window_set_focus(CtkWindow* window, CtkWidget* widget);
void ctk_window_raise(CtkWindow* window);
void ctk_window_set_policy(CtkWindow* window, gboolean canShrink, 
	gboolean canGrow, gboolean autoShrink);
void ctk_window_set_autocenter(CtkWindow* window, gboolean autoCenter);
void ctk_window_set_movable(CtkWindow* window, gboolean movable);
void ctk_window_set_closable(CtkWindow* window, gboolean closable);

/* FIXME: not a gtk call at all - want this to be part of a window manager */
CtkWindow* ctk_window_get_focus_window();
CtkWindow* ctk_window_container(CtkWidget* widget); /* what holds this widget */

/* Don't call these!! They are used in only two places */
void ctk_lose_focus();
void ctk_give_focus();

void ctk_window_min_size(CtkWidget* widget);

#endif
