/* 
 * $Id: ctkscrolledwindow.h,v 1.10 2000/07/26 22:31:16 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKSCROLLEDWINDOW_H__
#define __CTKSCROLLEDWINDOW_H__

#include "ctkadjustment.h"

struct CtkScrolledWindow_S {
	CtkBin bin;
	
	CtkAdjustment *hadjustment;
	CtkAdjustment *vadjustment;
	
	CtkPolicyType hscrollbar_policy;
	CtkPolicyType vscrollbar_policy;
	
	/* These are 0 or 1 (can use in adds) */
	gint hscrollbar_shown;
	gint vscrollbar_shown;
	
	gboolean locked_vertical;
	gboolean locked_horizontal;
};


#define CTK_SCROLLED_WINDOW(obj)	CTK_CHECK_CAST((obj),CtkScrolledWindow,CtkTypeScrolledWindow)

typedef struct CtkScrolledWindow_S CtkScrolledWindow;

void ctk_scrolled_window_init(CtkScrolledWindow *scrolledwindow);
void ctk_scrolled_window_scroll(CtkWidget *widget, CtkTypeScroll scroll_type);
CtkWidget *ctk_scrolled_window_new(CtkAdjustment *hadjustment,
				  CtkAdjustment *vadjustment);
void ctk_scrolled_window_set_policy(CtkScrolledWindow *scrolled_window, 
				    CtkPolicyType hscrollbar_policy,
				    CtkPolicyType vscrollbar_policy);
void ctk_scrolled_window_set_vadjustment(CtkScrolledWindow *scrolled_window,
					 CtkAdjustment *vadjustment);
void ctk_scrolled_window_set_hadjustment(CtkScrolledWindow *scrolled_window,
					 CtkAdjustment *hadjustment);
void ctk_scrolled_window_add_with_viewport(CtkScrolledWindow *scrolled_window,
					   CtkWidget *child);

#define CTK_SCROLLED_WINDOW(obj)	CTK_CHECK_CAST((obj),CtkScrolledWindow,CtkTypeScrolledWindow)

void ctk_scrolled_window_min_size(CtkWidget* widget);
void ctk_scrolled_window_real_size(CtkWidget* widget);

#endif
