/* 
 * $Id: ctkadjustment.c,v 1.12 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>

#include "ctk.h"

void
    ctk_adjustment_init(CtkAdjustment *adjustment)
{
	ctk_signal_new("changed",CtkTypeAdjustment);
	ctk_signal_new("value_changed",CtkTypeAdjustment);
	
	adjustment->value = 0;
	adjustment->lower = 0;
	adjustment->upper = 0;
	adjustment->step_increment = 0;
	adjustment->page_increment = 0;
	adjustment->page_size = 0;
	adjustment->slider_len = 0;
	adjustment->slider_col = 0;
	adjustment->slider_row = 0;
	
	ctk_data_init(&adjustment->data);
}

CtkObject *
    ctk_adjustment_new(gint value,
		       gint lower, 
		       gint upper,
		       gint step_increment,
		       gint page_increment,
		       gint page_size)
{
	CtkAdjustment *adjustment;

	adjustment = g_malloc(sizeof(CtkAdjustment));

	ctk_adjustment_init(adjustment);

	if (value < lower)
	    value = lower;
	else if (value > upper)
	    value = upper;

	((CtkObject *)adjustment)->type = CtkTypeAdjustment;
	adjustment->value = value;
	adjustment->lower = lower;
	adjustment->upper = upper;
	adjustment->step_increment = step_increment;
	adjustment->page_increment = page_increment;
	adjustment->page_size = page_size;

	return ((CtkObject *)adjustment);
}

/* Set the value of an adjustment */
void
    ctk_adjustment_set_value(CtkAdjustment *adjustment, gfloat value)
{
	if (!adjustment)
	    return;
	
	if (value < adjustment->lower)
	    adjustment->value = adjustment->lower;
	else if (value > adjustment->upper)
	    adjustment->value = adjustment->upper;
	else
	    adjustment->value = value;
}

/* Value Changed */
void
    ctk_adjustment_value_changed(CtkAdjustment *adjustment)
{
	if (!adjustment)
	    return;
	
	ctk_signal_emit_by_name(CTK_OBJECT(adjustment),"value_changed");
}
