/* 
 * $Id: ctklist.c,v 1.4 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <glib.h>

#include "ctk.h"

void ctk_list_init(CtkList* list)
{
	ctk_clist_init(&list->clist, 1);
	
	CTK_OBJECT(list)->type = CtkTypeList;
}

CtkWidget* ctk_list_new()
{
	CtkList* list;
	
	list = g_malloc(sizeof(CtkList));
	ctk_list_init(list);
	
	return CTK_WIDGET(list);
}

void ctk_list_append_items(CtkList* list, GList* items)
{
	CtkWidget* widgets[2];
	widgets[1] = NULL;
	
	while (items)
	{
		widgets[0] = CTK_WIDGET(items->data);
		ctk_clist_append_widget(CTK_CLIST(list), widgets);
		items = items->next;
	}
}

void ctk_list_select_row(CtkList* list, gint row)
{
	ctk_clist_select_row(CTK_CLIST(list), row, 0);
}

void ctk_list_move_cursor(CtkList* list, gint amount)
{
	ctk_clist_move_cursor(CTK_CLIST(list), amount);
}
