/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__LISTCOLLEAGUE_HPP)
#include <ListColleague.hpp>
#endif

#if   !defined(__LISTEVENTS_HPP)
#include <ListEvents.hpp>
#endif

#if   !defined(__LISTMEMENTOS_HPP)
#include <ListMementos.hpp>
#endif

using namespace corelinux;

// Some startup strings

static   string   ent1("First Line");
static   string   ent2("Second Line");
static   string   ent3("Third Line");
static   string   ent4("Fourth Line");

// Constructor

ListColleague::ListColleague( ListMediatorPtr aPtr )
   :
   Colleague( MediatorPtr(aPtr) ),
   theList()
{
   theList.push_back(ent1);  
   theList.push_back(ent2);  
   theList.push_back(ent3);  
   theList.push_back(ent4);  
}

// Copy constructor 

ListColleague::ListColleague( ListColleagueCref aColleague )
   :
   Colleague( aColleague ),
   theList( aColleague.theList )
{
   ;  // do nothing
}

// Destructor

ListColleague::~ListColleague( void )
{
   theList.clear();
}

// Assignment

ListColleagueRef  ListColleague::operator=( ListColleagueCref aColleague )
{
   if( *this == aColleague )
   {
      ;  // do nothing
   }
   else
   {
      theList.clear();
      theList = aColleague.theList;
   }

   return ( *this );
}

// Equality

bool ListColleague::operator==( ListColleagueCref aColleague ) const
{
   return ( this == &aColleague );
}

// Get the events I generate

void  ListColleague::getEventsGenerated( EventIdentifiersRef aVector ) 
{
   aVector.push_back( &ListChanged );
}

// Get the events I am interested in

void  ListColleague::getInterestedEvents( EventIdentifiersRef aVector ) 
{
   aVector.push_back( &EditedEntry );
}

// Initialization called by mediator

void ListColleague::initialize( void )
{
   //
   // Send the list out for discovery
   //
   ListEvent   aEv( ListChanged, new ChangedListMemento( theList ) );
   Colleague::invokeMediator( (Event<Identifier>*)&aEv );
}

// Called when a event comes my way

void  ListColleague::action( Event<Identifier> *aEvent ) 
{
   //
   // We deal with the list change
   //

   EditSelectionMementoRef   aChange = 
      dynamic_cast<EditSelectionMementoRef>
         (
            dynamic_cast<ListEventPtr>(aEvent)->getMemento()
         );

   string   & originalText( aChange.getSelected() );
   string   & changedText( aChange.getChange() );

   size_t   count = theList.size();
   for( size_t x = 0; x < count; ++x )
   {
      if( theList[x] == originalText )
      {
         theList[x] = changedText;
         x = count;
      }
      else
      {
         ;  // do nothing
      }
   }

   //
   // Then let colleagues know the new list 
   //

   this->initialize();

}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/07 03:46:00 $
   $Locker:  $
*/


