#if   !defined(__NAMEIDENTIFIER_HPP)
#define  __NAMEIDENTIFIER_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)                     
#include <Common.hpp>
#endif

#if   !defined(__IDENTIFIER_HPP)
#include <Identifier.hpp>
#endif

#include <string>

DECLARE_TYPE( std::string, Name );

/**
NameIdentifier is a string identifier.
*/

DECLARE_CLASS( NameIdentifier );

class NameIdentifier : public CORELINUX(Identifier)
{
public:

   //
   // Constructors and destructors
   //
                  
                        /// Instance constructor
                     
                        NameIdentifier( NameCref );

                        /// Copy constructor 
                     
                        NameIdentifier( NameIdentifierCref ) ;

                        /// Virtual destructor

   virtual              ~NameIdentifier( void );

   //
   // Operator overloads 
   //

            /// Assignment operator

            NameIdentifierRef operator=( NameIdentifierCref );

            /// Equality operator

            bool        operator==( NameIdentifierCref );
   //
   // Accessors
   //
            /// Retrieve the name for this identifier

            NameCref    getName( void ) const;

protected:

   //
   // Constructors
   //
                     /// Must have identity

                     NameIdentifier( void ) throw(CORELINUX(Assertion));


   //
   // Identifier overloads
   //
            /**
            Equality method
            @param Identifier const reference
            @return true if equal, false otherwise
            */
      
   virtual  bool        isEqual( CORELINUX(IdentifierCref) ) const ;
      
            /**
            Less than method
            @param Identifier const reference
            @return true if less than, false otherwise
            */
      
   virtual  bool        isLessThan( CORELINUX(IdentifierCref) ) const ;
      
            /**
            Less than or equal method.
            @param Identifier const reference
            @return true if less than or equal, false otherwise
            */
      
   virtual  bool        isLessThanOrEqual
                           ( 
                              CORELINUX(IdentifierCref) 
                           ) const ;
      
            /**
            Greater than method.
            @param Identifier const reference
            @return true if greater than, false otherwise
            */
      
   virtual  bool        isGreaterThan( CORELINUX(IdentifierCref) ) const ;
      
            /**
            Greater than or equal method.
            @param Identifier const reference
            @return true if greater than or equal, false otherwise
            */

   virtual  bool        isGreaterThanOrEqual
                           ( 
                              CORELINUX(IdentifierCref) 
                           ) const ;

private:

            Name           theName;          /// Instance name

};

#endif // if   !defined(__NAMEIDENTIFIER_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/21 02:38:47 $
   $Locker:  $
*/


