#if   !defined(__HELPHANDLER_HPP)
#define  __HELPHANDLER_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__HANDLER_HPP)
#include <corelinux/Handler.hpp>
#endif

#if   !defined(__HELPREQUEST_HPP)
#include <HelpRequest.hpp>
#endif

DECLARE_CLASS( HelpHandler );

/**
HelpHandler is the basic handler type for this example.
If fields the handlesType query from the base corelinux::Handler
from information compared in itself and the request. 
*/

class HelpHandler : public CORELINUX( Handler )
{
public:

   //
   // Constructors and destructor
   //
            /// Default constructor

            HelpHandler( HelpTopicCref );

            /// Copy constructor

            HelpHandler( HelpHandlerCref );

            /// Virtual destructor

   virtual  ~HelpHandler( void );

   //
   // Operator overloads
   //

            /// Assignment operator

            HelpHandlerRef operator=( HelpHandlerCref );

            /// Equality operator

            bool  operator==( HelpHandlerCref ) const;

   //
   // Accessors
   //
            /// Retrieves the type handled by this Handler

            HelpTopicCref  getTypeHandled( void ) const;
               

protected:

            /// Bad, needs type

            HelpHandler( void ) 
               throw ( CORELINUX(Assertion) );

            /// Determines if the handler supports the Request

   virtual  bool  handlesType( CORELINUX( RequestPtr ) );

private:

            /// Topic handled type

            HelpTopic   theTypeHandled;
};

#endif // if !defined(__HELPHANDLER_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/27 14:32:21 $
   $Locker:  $
*/

