
/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__GUARDSEMAPHORE_HPP)
#include <GuardSemaphore.hpp>
#endif

extern   "C"
{
   #include <sys/sem.h>
}
namespace corelinux
{
   //
   // Default constructor not allowed
   //

   GuardSemaphore::GuardSemaphore( void ) throw(Assertion)
      :
      Semaphore()
   {
      NEVER_GET_HERE;
   }

   //
   // Copy constructor not allowed
   //

   GuardSemaphore::GuardSemaphore( GuardSemaphoreCref ) throw(Assertion)
      :
      Semaphore()
   {
      NEVER_GET_HERE;
   }

   //
   // Default constructor to use
   //

   GuardSemaphore::GuardSemaphore
      ( 
         SemaphoreGroupPtr aGroup,
         SemaphoreIdentifierRef aIdentifier
      ) throw(Assertion)
      :
      Semaphore(aGroup, aIdentifier, false, false)
   {
      setValue(1);
   }

   //
   // Virtual Destructor
   //

   GuardSemaphore::~GuardSemaphore( void )
   {
      ; // do nothing
   }
   //
   // Returns true if lock value == 0
   //

   bool  GuardSemaphore::isLocked( void )
   {
      return !( getValue() );
   }

   //
   // Call for lock with wait disposition
   //

   SemaphoreOperationStatus GuardSemaphore::lockWithWait( void )
      throw(SemaphoreException)
   {

      SemaphoreOperationStatus   aStatus(SUCCESS);

      aStatus = setLock(0);
      return aStatus;
   }

   //
   // Call for lock without waiting
   //

   SemaphoreOperationStatus GuardSemaphore::lockWithNoWait( void )
      throw(SemaphoreException)
   {
      return setLock( IPC_NOWAIT );
   }

   //
   // Call release for lock
   //

   SemaphoreOperationStatus GuardSemaphore::release( void )
      throw(SemaphoreException)
   {
      SemaphoreOperationStatus   aStatus( SUCCESS );

      aStatus = setUnlock( IPC_NOWAIT );
      return aStatus;
   }
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/06/02 11:51:52 $
   $Locker:  $
*/




