/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include "complearn-rcbzlib.h"

#include "complearn-rcbzlib-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 11 "complearn-rcbzlib.gob"


/*
Copyright (c) 2003-2008 Rudi Cilibrasi, Rulers of the RHouse
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. Neither the name of the University nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE RULERS AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE RULERS OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
*/
#include <libintl.h>
#include "complearn.h"
#include "privconf.h"

#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#endif

#if HAVE_BZLIB_H
#include <bzlib.h>
#endif

#include <string.h>


struct BZ2DynamicAdaptorCB {
  int (*buftobufcompress)(char *dbuff,unsigned int *p,
    char *src, unsigned int sz, int blocksize, int verblevel, int workfactor);
  int (*buftobufdecompress)(char *dbuff,unsigned int *p,
    char *src, unsigned int sz, int small, int verblevel);
};

static struct BZ2DynamicAdaptorCB *complearn_grab_bz2_dacb(void);

#if HAVE_BZLIB_H
static struct BZ2DynamicAdaptorCB bzlibsda = {
  BZ2_bzBuffToBuffCompress,
  BZ2_bzBuffToBuffDecompress
};
#else
static struct BZ2DynamicAdaptorCB bzlibsda;
#endif

static int haveTriedDL; /* Singleton */

static struct BZ2DynamicAdaptorCB *complearn_grab_bz2_dacb(void) {
  if (bzlibsda.buftobufcompress)
    return &bzlibsda;
  if (!haveTriedDL) {
    void *lib_handle;
    haveTriedDL = 1;
#if HAVE_DLFCN_H
    lib_handle = dlopen("libbz2.so", RTLD_LAZY);
    if (lib_handle) {
      bzlibsda.buftobufcompress= dlsym(lib_handle,"BZ2_bzBuffToBuffCompress");
      bzlibsda.buftobufdecompress= dlsym(lib_handle,"BZ2_bzBuffToBuffDecompress");
    }
#endif
  }
  return bzlibsda.buftobufcompress ? &bzlibsda : NULL;
}


#define _( O ) gettext( O )
static GString *priv_decompress(CompLearnRealCompressor *rc,const GString *src)
{
  struct BZ2DynamicAdaptorCB *bzlib = complearn_grab_bz2_dacb();
  GString *result = NULL;
  if (bzlib) {
    int i;
    unsigned char *dbuff = NULL;
    unsigned int p;
    unsigned int sp;
    p = src->len + 12;
    do {
      p = 2*p;
      if (dbuff != NULL)
        free(dbuff);
      dbuff = (unsigned char*)calloc(1,p);
      sp = p;
      i = (bzlib->buftobufdecompress)((char *) dbuff,(unsigned int *) &sp, (char *) src->str,src->len,
complearn_rcbzlib_get_small(COMPLEARN_RCBZLIB(rc)) ? 1 : 0,
complearn_rcbzlib_get_verbosity(COMPLEARN_RCBZLIB(rc)));
    } while (i == -8);  /* OUTBUF_FULL */
    if (i == 0)               /* OK */
      result = g_string_new_len((char *) dbuff,sp);
    free(dbuff);
     } else {
      /* TODO: GError here */
     }
  return result;
}

#line 138 "complearn-rcbzlib.c"
/* self casting macros */
#define SELF(x) COMPLEARN_RCBZLIB(x)
#define SELF_CONST(x) COMPLEARN_RCBZLIB_CONST(x)
#define IS_SELF(x) COMPLEARN_IS_RCBZLIB(x)
#define TYPE_SELF COMPLEARN_TYPE_RCBZLIB
#define SELF_CLASS(x) COMPLEARN_RCBZLIB_CLASS(x)

#define SELF_GET_CLASS(x) COMPLEARN_RCBZLIB_GET_CLASS(x)

/* self typedefs */
typedef CompLearnRCBZLib Self;
typedef CompLearnRCBZLibClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void complearn_rcbzlib_init (CompLearnRCBZLib * o) G_GNUC_UNUSED;
static void complearn_rcbzlib_class_init (CompLearnRCBZLibClass * c) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_SMALL,
	PROP_VERBOSITY,
	PROP_WINDOW_BLOCK_SIZE,
	PROP_WORK_FACTOR
};

/* pointer to the class of our parent */
static CompLearnRealCompressorAdaptorClass *parent_class = NULL;

/* Short form macros */
#define self_get_small complearn_rcbzlib_get_small
#define self_set_small complearn_rcbzlib_set_small
#define self_get_verbosity complearn_rcbzlib_get_verbosity
#define self_set_verbosity complearn_rcbzlib_set_verbosity
#define self_get_window_block_size complearn_rcbzlib_get_window_block_size
#define self_set_window_block_size complearn_rcbzlib_set_window_block_size
#define self_get_work_factor complearn_rcbzlib_get_work_factor
#define self_set_work_factor complearn_rcbzlib_set_work_factor
#define self_new complearn_rcbzlib_new
#define self_compress complearn_rcbzlib_compress
#define self_decompress complearn_rcbzlib_decompress
#define self_blurb complearn_rcbzlib_blurb
#define self_name complearn_rcbzlib_name
#define self_compressor_version complearn_rcbzlib_compressor_version
#define self_is_decompressible complearn_rcbzlib_is_decompressible
#define self_window_size complearn_rcbzlib_window_size
#define self_is_operational complearn_rcbzlib_is_operational
#define self_clone complearn_rcbzlib_clone
#define self_is_threadsafe complearn_rcbzlib_is_threadsafe


static void
___CompLearn_Real_Compressor_init (CompLearnRealCompressorIface *iface)
{
#line 170 "complearn-rcbzlib.gob"
	iface->compress = self_compress;
#line 195 "complearn-rcbzlib.gob"
	iface->decompress = self_decompress;
#line 199 "complearn-rcbzlib.gob"
	iface->blurb = self_blurb;
#line 203 "complearn-rcbzlib.gob"
	iface->name = self_name;
#line 207 "complearn-rcbzlib.gob"
	iface->compressor_version = self_compressor_version;
#line 211 "complearn-rcbzlib.gob"
	iface->is_decompressible = self_is_decompressible;
#line 221 "complearn-rcbzlib.gob"
	iface->window_size = self_window_size;
#line 225 "complearn-rcbzlib.gob"
	iface->is_operational = self_is_operational;
#line 229 "complearn-rcbzlib.gob"
	iface->clone = self_clone;
#line 238 "complearn-rcbzlib.gob"
	iface->is_threadsafe = self_is_threadsafe;
#line 214 "complearn-rcbzlib.c"
}

GType
complearn_rcbzlib_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (CompLearnRCBZLibClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) complearn_rcbzlib_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (CompLearnRCBZLib),
			0 /* n_preallocs */,
			(GInstanceInitFunc) complearn_rcbzlib_init,
			NULL
		};

		static const GInterfaceInfo CompLearn_Real_Compressor_info = {
			(GInterfaceInitFunc) ___CompLearn_Real_Compressor_init,
			NULL,
			NULL
		};

		type = g_type_register_static (COMPLEARN_TYPE_REAL_COMPRESSOR_ADAPTOR, "CompLearnRCBZLib", &info, (GTypeFlags)0);
		g_type_add_interface_static (type,
			COMPLEARN_TYPE_REAL_COMPRESSOR,
			&CompLearn_Real_Compressor_info);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((CompLearnRCBZLib *)g_object_new(complearn_rcbzlib_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static CompLearnRCBZLib * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static CompLearnRCBZLib *
GET_NEW_VARG (const char *first, ...)
{
	CompLearnRCBZLib *ret;
	va_list ap;
	va_start (ap, first);
	ret = (CompLearnRCBZLib *)g_object_new_valist (complearn_rcbzlib_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::finalize"
	CompLearnRCBZLib *self G_GNUC_UNUSED = COMPLEARN_RCBZLIB (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
complearn_rcbzlib_init (CompLearnRCBZLib * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,COMPLEARN_TYPE_RCBZLIB,CompLearnRCBZLibPrivate);
}
#undef __GOB_FUNCTION__
static void 
complearn_rcbzlib_class_init (CompLearnRCBZLibClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(CompLearnRCBZLibPrivate));

	parent_class = g_type_class_ref (COMPLEARN_TYPE_REAL_COMPRESSOR_ADAPTOR);

	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_boolean
		("small" /* name */,
		 _("small") /* nick */,
		 _("Small memory footprint") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_SMALL,
		param_spec);
	param_spec = g_param_spec_int
		("verbosity" /* name */,
		 _("verbosity") /* nick */,
		 _("BZip2 Verbosity Level") /* blurb */,
		 0 /* minimum */,
		 4 /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_VERBOSITY,
		param_spec);
	param_spec = g_param_spec_int
		("window_block_size" /* name */,
		 _("window-block-size") /* nick */,
		 _("Window size in 100000-byte chunks") /* blurb */,
		 1 /* minimum */,
		 9 /* maximum */,
		 9 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_WINDOW_BLOCK_SIZE,
		param_spec);
	param_spec = g_param_spec_int
		("work_factor" /* name */,
		 _("work-factor") /* nick */,
		 _("Work factor for bzlib") /* blurb */,
		 0 /* minimum */,
		 250 /* maximum */,
		 30 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_WORK_FACTOR,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::set_property"
{
	CompLearnRCBZLib *self G_GNUC_UNUSED;

	self = COMPLEARN_RCBZLIB (object);

	switch (property_id) {
	case PROP_SMALL:
		{
#line 128 "complearn-rcbzlib.gob"
self->_priv->small = g_value_get_boolean (VAL);
#line 365 "complearn-rcbzlib.c"
		}
		break;
	case PROP_VERBOSITY:
		{
#line 136 "complearn-rcbzlib.gob"
self->_priv->verbosity = g_value_get_int (VAL);
#line 372 "complearn-rcbzlib.c"
		}
		break;
	case PROP_WINDOW_BLOCK_SIZE:
		{
#line 146 "complearn-rcbzlib.gob"
self->_priv->window_block_size = g_value_get_int (VAL);
#line 379 "complearn-rcbzlib.c"
		}
		break;
	case PROP_WORK_FACTOR:
		{
#line 156 "complearn-rcbzlib.gob"
self->_priv->work_factor = g_value_get_int (VAL);
#line 386 "complearn-rcbzlib.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::get_property"
{
	CompLearnRCBZLib *self G_GNUC_UNUSED;

	self = COMPLEARN_RCBZLIB (object);

	switch (property_id) {
	case PROP_SMALL:
		{
#line 128 "complearn-rcbzlib.gob"
g_value_set_boolean (VAL, self->_priv->small);
#line 417 "complearn-rcbzlib.c"
		}
		break;
	case PROP_VERBOSITY:
		{
#line 136 "complearn-rcbzlib.gob"
g_value_set_int (VAL, self->_priv->verbosity);
#line 424 "complearn-rcbzlib.c"
		}
		break;
	case PROP_WINDOW_BLOCK_SIZE:
		{
#line 146 "complearn-rcbzlib.gob"
g_value_set_int (VAL, self->_priv->window_block_size);
#line 431 "complearn-rcbzlib.c"
		}
		break;
	case PROP_WORK_FACTOR:
		{
#line 156 "complearn-rcbzlib.gob"
g_value_set_int (VAL, self->_priv->work_factor);
#line 438 "complearn-rcbzlib.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 128 "complearn-rcbzlib.gob"
gboolean 
complearn_rcbzlib_get_small (CompLearnRCBZLib * self)
#line 458 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::get_small"
{
#line 128 "complearn-rcbzlib.gob"
		gboolean val; g_object_get (G_OBJECT (self), "small", &val, NULL); return val;
}}
#line 465 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 128 "complearn-rcbzlib.gob"
void 
complearn_rcbzlib_set_small (CompLearnRCBZLib * self, gboolean val)
#line 471 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::set_small"
{
#line 128 "complearn-rcbzlib.gob"
		g_object_set (G_OBJECT (self), "small", val, NULL);
}}
#line 478 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 136 "complearn-rcbzlib.gob"
gint 
complearn_rcbzlib_get_verbosity (CompLearnRCBZLib * self)
#line 484 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::get_verbosity"
{
#line 136 "complearn-rcbzlib.gob"
		gint val; g_object_get (G_OBJECT (self), "verbosity", &val, NULL); return val;
}}
#line 491 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 136 "complearn-rcbzlib.gob"
void 
complearn_rcbzlib_set_verbosity (CompLearnRCBZLib * self, gint val)
#line 497 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::set_verbosity"
{
#line 136 "complearn-rcbzlib.gob"
		g_object_set (G_OBJECT (self), "verbosity", val, NULL);
}}
#line 504 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 146 "complearn-rcbzlib.gob"
gint 
complearn_rcbzlib_get_window_block_size (CompLearnRCBZLib * self)
#line 510 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::get_window_block_size"
{
#line 146 "complearn-rcbzlib.gob"
		gint val; g_object_get (G_OBJECT (self), "window_block_size", &val, NULL); return val;
}}
#line 517 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 146 "complearn-rcbzlib.gob"
void 
complearn_rcbzlib_set_window_block_size (CompLearnRCBZLib * self, gint val)
#line 523 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::set_window_block_size"
{
#line 146 "complearn-rcbzlib.gob"
		g_object_set (G_OBJECT (self), "window_block_size", val, NULL);
}}
#line 530 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 156 "complearn-rcbzlib.gob"
gint 
complearn_rcbzlib_get_work_factor (CompLearnRCBZLib * self)
#line 536 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::get_work_factor"
{
#line 156 "complearn-rcbzlib.gob"
		gint val; g_object_get (G_OBJECT (self), "work_factor", &val, NULL); return val;
}}
#line 543 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 156 "complearn-rcbzlib.gob"
void 
complearn_rcbzlib_set_work_factor (CompLearnRCBZLib * self, gint val)
#line 549 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::set_work_factor"
{
#line 156 "complearn-rcbzlib.gob"
		g_object_set (G_OBJECT (self), "work_factor", val, NULL);
}}
#line 556 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 165 "complearn-rcbzlib.gob"
GObject * 
complearn_rcbzlib_new (void)
#line 562 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::new"
{
#line 166 "complearn-rcbzlib.gob"
	
    GObject *ret = (GObject *) GET_NEW;
    return G_OBJECT (ret);
  }}
#line 571 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 170 "complearn-rcbzlib.gob"
GString * 
complearn_rcbzlib_compress (CompLearnRealCompressor * rc, const GString * src)
#line 577 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::compress"
{
#line 171 "complearn-rcbzlib.gob"
	
    GString *result = NULL;
    struct BZ2DynamicAdaptorCB *bzlib = complearn_grab_bz2_dacb();
    int s;

    unsigned char *dbuff;
    unsigned int p;

    if (bzlib == NULL)
      return result;

    p = (int)(src->len*1.2) + 200;
  dbuff = (unsigned char*)g_malloc(p);
  s = (bzlib->buftobufcompress)((char *) dbuff,&p,(char *) (src->str),src->len,
complearn_rcbzlib_get_window_block_size(COMPLEARN_RCBZLIB(rc)),
complearn_rcbzlib_get_verbosity(COMPLEARN_RCBZLIB(rc)),
complearn_rcbzlib_get_work_factor(COMPLEARN_RCBZLIB(rc)));
  if (s != 0) {    /* Z_OK */
    /* TODO: */
  }
  result = g_string_new_len((char *) dbuff, p);
  g_free(dbuff);
  return result;
  }}
#line 606 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 195 "complearn-rcbzlib.gob"
GString * 
complearn_rcbzlib_decompress (CompLearnRealCompressor * rc, const GString * src)
#line 612 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::decompress"
{
#line 196 "complearn-rcbzlib.gob"
	
    return priv_decompress(rc, src);
  }}
#line 620 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 199 "complearn-rcbzlib.gob"
GString * 
complearn_rcbzlib_blurb (CompLearnRealCompressor * rc)
#line 626 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::blurb"
{
#line 200 "complearn-rcbzlib.gob"
	
    return g_string_new(_("libbz2 (a.k.a. bzlib) blocksort style"));
  }}
#line 634 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 203 "complearn-rcbzlib.gob"
GString * 
complearn_rcbzlib_name (CompLearnRealCompressor * rc)
#line 640 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::name"
{
#line 204 "complearn-rcbzlib.gob"
	
    return g_string_new("bzlib");
  }}
#line 648 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 207 "complearn-rcbzlib.gob"
GString * 
complearn_rcbzlib_compressor_version (CompLearnRealCompressor * rc)
#line 654 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::compressor_version"
{
#line 208 "complearn-rcbzlib.gob"
	
    return g_string_new("1.0.3");
  }}
#line 662 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 211 "complearn-rcbzlib.gob"
gboolean 
complearn_rcbzlib_is_decompressible (CompLearnRealCompressor * rc, const GString * input)
#line 668 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::is_decompressible"
{
#line 212 "complearn-rcbzlib.gob"
	
    if (input->len < 3 || (guchar) input->str[0] != 0x42 ||
        (guchar) input->str[1] != 0x5a || (guchar) input->str[2] != 0x68)
      return FALSE;
    GString *t = priv_decompress(rc, input);
    if (t != NULL)
      g_string_free(t, TRUE);
    return t != NULL;
  }}
#line 682 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 221 "complearn-rcbzlib.gob"
guint64 
complearn_rcbzlib_window_size (CompLearnRealCompressor * rc)
#line 688 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::window_size"
{
#line 222 "complearn-rcbzlib.gob"
	
    return COMPLEARN_RCBZLIB(rc)->_priv->window_block_size*8*100000;
  }}
#line 696 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 225 "complearn-rcbzlib.gob"
gboolean 
complearn_rcbzlib_is_operational (CompLearnRealCompressor * rc)
#line 702 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::is_operational"
{
#line 226 "complearn-rcbzlib.gob"
	
    return complearn_grab_bz2_dacb() != NULL;
  }}
#line 710 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 229 "complearn-rcbzlib.gob"
CompLearnRealCompressor * 
complearn_rcbzlib_clone (CompLearnRealCompressor * rc)
#line 716 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::clone"
{
#line 230 "complearn-rcbzlib.gob"
	
    CompLearnRCBZLib *res = COMPLEARN_RCBZLIB(complearn_rcbzlib_new());
    complearn_rcbzlib_set_window_block_size(res, complearn_rcbzlib_get_window_block_size(COMPLEARN_RCBZLIB(rc)));
    complearn_rcbzlib_set_small(res, complearn_rcbzlib_get_small(COMPLEARN_RCBZLIB(rc)));
    complearn_rcbzlib_set_verbosity(res, complearn_rcbzlib_get_verbosity(COMPLEARN_RCBZLIB(rc)));
    complearn_rcbzlib_set_work_factor(res, complearn_rcbzlib_get_work_factor(COMPLEARN_RCBZLIB(rc)));
    return COMPLEARN_REAL_COMPRESSOR(res);
    }}
#line 729 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__

#line 238 "complearn-rcbzlib.gob"
gboolean 
complearn_rcbzlib_is_threadsafe (CompLearnRealCompressor * rc)
#line 735 "complearn-rcbzlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCBZLib::is_threadsafe"
{
#line 239 "complearn-rcbzlib.gob"
	
    return TRUE;
  }}
#line 743 "complearn-rcbzlib.c"
#undef __GOB_FUNCTION__
