#include "ortho.h"

#include <GL/glu.h>

static void cm_ortho_render (CmNode *node, CmState *state);

G_DEFINE_TYPE (CmOrtho, cm_ortho, CM_TYPE_NODE);

static void
cm_ortho_finalize (GObject *object)
{
    CmOrtho *ortho = CM_ORTHO (object);
    
    G_OBJECT_CLASS (cm_ortho_parent_class)->finalize (object);

    cm_node_disown_child (CM_NODE (ortho), &ortho->child);
}

static void
cm_ortho_class_init (CmOrthoClass *class)
{
    GObjectClass *object_class = G_OBJECT_CLASS (class);
    CmNodeClass *node_class = CM_NODE_CLASS (class);
    
    object_class->finalize = cm_ortho_finalize;
    node_class->render = cm_ortho_render;
}

static void
cm_ortho_init (CmOrtho *ortho)
{
    
}

static void
cm_ortho_render (CmNode *node,
		 CmState *state)
{
    CmOrtho *ortho = CM_ORTHO (node);
    
    glPushMatrix ();

    gluOrtho2D (ortho->x, ortho->x + ortho->width,
		ortho->y + ortho->height, ortho->y);
    
    cm_node_render (ortho->child, state);

    glPopMatrix();
}

CmOrtho *
cm_ortho_new (CmNode *child,
	      int x, int y,
	      int width, int height)
{
    CmOrtho *ortho = g_object_new (CM_TYPE_ORTHO, NULL);

    ortho->x = x;
    ortho->y = y;
    ortho->width = width;
    ortho->height = height;

    cm_node_own_child (CM_NODE (ortho), &ortho->child, child);
    
    return ortho;
}

void
cm_ortho_set_axes (CmOrtho *ortho,
		   int x, int y,
		   int width, int height)
{
    g_return_if_fail (CM_IS_ORTHO (ortho));

    ortho->x = x;
    ortho->y = y;
    ortho->width = width;
    ortho->height = height;

    cm_node_queue_repaint (CM_NODE (ortho));
}

