/*
  CLAW - a C++ Library Absolutely Wonderful

  CLAW is a free library without any particular aim but being useful to 
  anyone.

  Copyright (C) 2005-2008 Julien Jorge

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: julien_jorge@yahoo.fr
*/
/**
 * \file algorithm.hpp
 * \brief Generic algorithms on sequences.
 * \author Julien Jorge
 */
#ifndef __CLAW_ALGORITHM_HPP__
#define __CLAW_ALGORITHM_HPP__

namespace claw
{
  /**
   * \brief Apply an unary function to all members of a sequence.
   *
   * This function works like std::for_each() but allows the function to apply
   * non-const methods to its argument.
   *
   * \param first Iterator on the first element of the sequence.
   * \param last Iterator just past the end of the sequence.
   * \param f Function to apply to the elements of the sequence.
   *
   * \remark The return value of the unary function is ignored.
   */
  template<typename InputIterator, typename UnaryFunction>
  UnaryFunction inplace_for_each( InputIterator first, InputIterator last,
                                  UnaryFunction f )
  {
    for (; first!=last; ++first)
      f(*first);

    return f;
  } // inplace_for_each()

} // namespace claw

#endif // __CLAW_ALGORITHM_HPP__
