/***************************************************************************
 *   Copyright (C) 2003 by Miguel Revilla Rodrguez                        *
 *   yo@miguelrevilla.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

 /* This is the libcdg123 header file */
 
 
#define CDG_MEMORYPRESET        1
#define CDG_BORDERPRESET        2
#define CDG_TILEBLOCKNORMAL     6
#define CDG_SCROLLPRESET        20
#define CDG_SCROLLCOPY          24
#define CDG_TRANSPARENTCOLOR    28
#define CDG_COLORTABLELO        30
#define CDG_COLORTABLEUP        31
#define CDG_TILEBLOCKXOR        38

#define CDG_FRAMEWIDTH          300
#define CDG_FRAMEHEIGHT         216
#define CDG_BORDERWIDTH         6
#define CDG_BORDERHEIGHT        12
#define CDG_RGBAFRAMESIZE       (CDG_FRAMEWIDTH * CDG_FRAMEHEIGHT * 4)

struct cdgSubChannelChunk {
        char command ;
        char instruction ;
        char parityQ[2] ;
        char data[16] ;
        char parityP[4] ;
} ;

struct cdgStream {
        int colorTable[16][3] ;
        char pixelMatrix[CDG_FRAMEWIDTH*CDG_FRAMEHEIGHT] ;
        int borderColor ;
        int transparentColor ;
} ;

int cdgDriveCapable (char *drive) ;

int cdgIdChunk (struct cdgSubChannelChunk *chunk) ;

int cdgInitStream (struct cdgStream *stream) ;

int cdgInitRGBA (char *rgbbuf) ;
