/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageDataContainer;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;
import net.sourceforge.cobertura.coveragedata.SourceFileData;

public class PackageData
extends CoverageDataContainer
implements Comparable,
HasBeenInstrumented {
    private static final long serialVersionUID = 7L;
    private String name;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$PackageData;

    public PackageData(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Package name must be specified.");
        }
        this.name = name;
    }

    public void addClassData(ClassData classData) {
        if (this.children.containsKey(classData.getBaseName())) {
            throw new IllegalArgumentException("Package " + this.name + " already contains a class with the name " + classData.getBaseName());
        }
        this.children.put(classData.getBaseName(), classData);
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(class$net$sourceforge$cobertura$coveragedata$PackageData == null ? (class$net$sourceforge$cobertura$coveragedata$PackageData = PackageData.class$("net.sourceforge.cobertura.coveragedata.PackageData")) : class$net$sourceforge$cobertura$coveragedata$PackageData)) {
            return Integer.MAX_VALUE;
        }
        return this.name.compareTo(((PackageData)o).name);
    }

    public boolean contains(String name) {
        return this.children.containsKey(name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        PackageData packageData = (PackageData)obj;
        return super.equals(obj) && this.name.equals(packageData.name);
    }

    public SortedSet getClasses() {
        return new TreeSet(this.children.values());
    }

    public String getName() {
        return this.name;
    }

    public String getSourceFileName() {
        return this.name.replace('.', '/');
    }

    public Collection getSourceFiles() {
        TreeMap<String, SourceFileData> sourceFileDatas = new TreeMap<String, SourceFileData>();
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            ClassData classData = (ClassData)iter.next();
            String sourceFileName = classData.getSourceFileName();
            SourceFileData sourceFileData = (SourceFileData)sourceFileDatas.get(sourceFileName);
            if (sourceFileData == null) {
                sourceFileData = new SourceFileData(sourceFileName);
                sourceFileDatas.put(sourceFileName, sourceFileData);
            }
            sourceFileData.addClassData(classData);
        }
        return sourceFileDatas.values();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

