/* 
 * $Id: cap_offset.h,v 1.2 2000/08/23 22:03:41 cbond Exp $
 *
 * libarr - a screen management toolkit
 *
 * Copyright (C) 2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Author: Chris Bond
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#if !defined(__include_cap_offset_h__)
#define __include_cap_offset_h__

/* cap_offset.h is a list of offsets for the termcap variables that we use.
 */

/* Screen manipulation variables:
 */
#define OFFSET_CO 0		/* columns on screen */
#define OFFSET_LI 2		/* lines on screen */
#define OFFSET_NP 25		/* padding character (bool) */
#define OFFSET_BL 1		/* beep */
#define OFFSET_CL 5		/* clear screen */
#define OFFSET_VI 13		/* hide cursor */
#define OFFSET_VE 16		/* show cursor */
#define OFFSET_CM 10		/* move cursor */
#define OFFSET_MD 27		/* bold mode */
#define OFFSET_SO 35		/* standout mode */
#define OFFSET_SE 43		/* exit standout mode */
#define OFFSET_ME 39		/* turn off all attributes */
#define OFFSET_AS 25		/* alternate charset mode */
#define OFFSET_AE 38		/* exit alternate charset mode */
#define OFFSET_AF 359		/* set foreground color */
#define OFFSET_AB 360		/* set background color */
#define OFFSET_PC 104		/* padding character (string) */
#define OFFSET_EA 155		/* enable alternate charset */
#define OFFSET_TI 28		/* start programs using cursor movement */
#define OFFSET_TE 40		/* end programs using cursor movement */

#define OFFSET_AC 146		/* graphical characters */

/* Keys from the terminfo file:
 */
#define OFFSET_AR 83		/* right arrow key */
#define OFFSET_AL 79		/* left arrow key */
#define OFFSET_AU 87		/* up arrow key */
#define OFFSET_AD 61		/* down arrow key */
#define OFFSET_KH 76		/* home key */
#define OFFSET_KE 164		/* end key */
#define OFFSET_KD 59		/* delete key */
#define OFFSET_KP 82		/* page up key */
#define OFFSET_KN 81		/* page down key */

#endif
