with Ada.Text_Io,
     X_Lib,
     X_Lib.Tasking,
     X_Toolkit,
     Xm_Widgets.Manager.Drawing_Area,
     Xm_Widgets.Manager.Scrolled_Window.Main_Window,
     Common,
     Motif_Graphics,
     Image_Global;
     
use  Ada.Text_Io;
use  Xm_Widgets,
     Xm_Widgets.Manager.Drawing_Area,
     Xm_Widgets.Manager.Scrolled_Window.Main_Window;

procedure Image is

   The_Main              : X_Toolkit.Widget;

   procedure Init_Work_Area is
      -- Colors
      Back          : X_Lib.Pixel;
      GC_Val        : X_Lib.X_GC_Values;
      GC_Mask       : X_Toolkit.Xt_GC_Mask;
      RGB, X_Col    : X_Lib.X_Color;

      Argl          : X_Toolkit.Arg_List := X_Toolkit.Null_Arg_List;

   begin
      Common.The_Draw  := X_Toolkit.Xt_Create_Managed_Widget
             ("draw", Xm_Drawing_Area_Widget_Class, The_Main);

      Common.Display   := X_Toolkit.Xt_Display (Common.Appshell);

      Common.Color_Map := X_Lib.X_Default_Colormap
             (Common.Display, X_Lib.X_Default_Screen (Common.Display));

      Common.Window    := X_Lib.X_Default_Root_Window (Common.Display);

      -- set default size
      Argl := X_Toolkit.Null_Arg_List;
      X_Toolkit.Append_Set (Argl, Xm_N_Width, X_Lib.Dimension'(320));
      X_Toolkit.Append_Set (Argl, Xm_N_Height, X_Lib.Dimension'(200));
      X_Toolkit.Xt_Set_Values (Common.The_Draw, Argl);

      Argl := X_Toolkit.Null_Arg_List;
      X_Toolkit.Append_Get (Argl, Xm_N_Background, Back);
      X_Toolkit.Xt_Get_Values (Common.The_Draw, Argl);

      Put_Line ("Back=" & X_Lib.Pixel'Image (Back));
      Flush;
      X_Lib.X_Alloc_Named_Color (Common.Display,
                                 Common.Color_Map,
                                 "ivory1", X_Col, RGB);

      -- set background to ivory1
      Back := X_Col.Pix;
      Argl := X_Toolkit.Null_Arg_List;
      X_Toolkit.Append_Set (Argl, Xm_N_Background, Back);
      X_Toolkit.Xt_Set_Values (Common.The_Draw, Argl);


      GC_Val.Background := Back;
      GC_Val.Fill_Style := X_Lib.Stippled;
      GC_Mask := (GC_Background | GC_Fill_Style => True, others => False);
      Common.GC := X_Toolkit.Xt_Get_GC (Common.The_Draw, GC_Mask, GC_Val);

      Motif_Graphics.Make_CRT;

      -- install the callbacks
      X_Toolkit.Xt_Add_Callback (Common.The_Draw,
                                 Xm_N_Expose_Callback,
                                 Image_Global.Expose_Image_CB'Access);
      X_Toolkit.Xt_Add_Callback (Common.The_Draw,
                                 Xm_N_Resize_Callback,
                                 Image_Global.Resize_Image_CB'Access);

   end Init_Work_Area;


begin
   X_Lib.Tasking.Resource.Seize;

   X_Toolkit.Xt_App_Initialize (Common.Appshell, Common.App_Con, "Image");

   The_Main   := Xm_Create_Main_Window (Common.Appshell, "mainwin");
   X_Toolkit.Xt_Manage_Child (The_Main);

   Init_Work_Area;

   Xm_Main_Window_Set_Areas (W => The_Main,
                      Menu_Bar => X_Toolkit.Null_Widget,
                Command_Window => X_Toolkit.Null_Widget,
          Horizontal_Scrollbar => X_Toolkit.Null_Widget,
            Vertical_Scrollbar => X_Toolkit.Null_Widget,
                   Work_Region => Common.The_Draw);

   X_Toolkit.Xt_Realize_Widget (Common.Appshell);

   Common.Timer_ID := X_Toolkit.Xt_App_Add_Time_Out
                  (App_Context => Common.App_Con,
                      Interval => 1000,           -- Milliseconds
                      Callback => Image_Global.Timeout_CB'Access,
                   Client_Data => X_Toolkit.Null_Xt_Pointer);

   -- to be sure it is called at least once
   Image_Global.Resize_Image (Common.The_Draw);

   X_Toolkit.Xt_App_Main_Loop (Common.App_Con);

   X_Lib.Tasking.Resource.Release;

end Image;
