:
#
# Copyright (c) 2004 by James A. McQuillan (McQuillan Systems)
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# MCQUILLAN SYSTEMS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
# OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#
# 03/16/2005 -Jim McQuillan- Changed it to install ltspinfo in /usr/bin,
#                            which now matches the rpm.
# 07/13/2004 -Jim McQuillan- Fixed testing of root.
# 07/12/2004 -Jim McQuillan- Added ltspinfo
# 06/24/2004 -Jim McQuillan- New package for the ltspadmin utility
#
##############################################################################

##############################################################################
#
# Make sure this script is being run by the superuser.
#
if [ "`id -u`" != "0" ]; then
    echo
    echo "You MUST run this script as superuser!"
    echo
    echo "If you logged in as a normal user then su'ed to become"
    echo "superuser, you also need to add a hyphen '-' to the"
    echo "su command".
    echo
    exit 1
fi

echo "Installing ltspadmin"
cp ltspadmin    /usr/sbin/ltspadmin
chmod 0755      /usr/sbin/ltspadmin
chown root:root /usr/sbin/ltspadmin

echo "Installing ltspcfg"
cp ltspcfg      /usr/sbin/ltspcfg
chmod 0755      /usr/sbin/ltspcfg
chown root:root /usr/sbin/ltspcfg

#
# Remove old ltspinfo which was in the wrong place.
#
if [ -f /usr/sbin/ltspinfo ]; then
  echo "Removing old ltspinfo"
  rm -f /usr/sbin/ltspinfo
fi

echo "Installing ltspinfo"
cp ltspinfo     /usr/bin/ltspinfo
chmod 0755      /usr/bin/ltspinfo
chown root:root /usr/bin/ltspinfo


echo
echo "Installation of ltsp-utils complete"
echo
