#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <misc.h>
#include "xconf.h"

/*
	Read a file holding a list of option (one line per option)
	Return the number of options placed in tbopt with strdup().
	Return -1 if any error. The caller must call free() for every
	item in tbopt[].
*/
int xconf_readflist(
	const char *fname,
	char *tbopt[],
	int maxopt)		// Maximum number of line allowed in tbopt[]
{
	int ret = -1;
	char path[PATH_MAX];
	strcpy (path,fname);
	FILE *fin = fopen (path,"r");
	if (fin == NULL){
		sprintf (path,USR_LIB_XCONF "/%s",fname);
		fin = fopen (path,"r");
	}
	if (fin == NULL){
		xconf_error (
			"The file %s can't be found\n"
			"It is normally found in " USR_LIB_XCONF "%s\n"
			,fname
			);
	}else{
		char buf[300];
		ret = 0;
		while (fgets(buf,sizeof(buf)-1,fin)!= NULL){
			str_strip (buf,buf);
			/* #Specification: data files / option list
				Files holding options list are ascii files.
				They contain one option per line. They may have
				blank lines. Line beginning with ; are comments
				and will be silently skipped.

				Trailing blanks are eliminated. Blanks at the
				beginning of the line are kept.

				Option usally begin with a keyword and then a description.
			*/
			if (buf[0] != ';' && buf[0] != '\0'){
				if (ret == maxopt){
					xconf_error (
						"Too many option in file %s\n",fname);
					break;
				}else{
					tbopt[ret++] = strdup(buf);
				}
			}
		}
		fclose (fin);
	}
	return ret;
}

