#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "netconf.h"
#include "../paths.h"
#include "netconf.m"
#include <dialog.h>
#include "internal.h"

extern NETCONF_HELP_FILE help_routes;
/*
	Check if a network number is compatible with a netmask.
	The netmask may be empty.
*/
EXPORT bool routes_validnet (const char *net, const char *mask)
{
	char def_msk[20];
	device_setstdnetmask(net,def_msk);
	if (mask == NULL || mask[0] == '\0') mask = def_msk;
	unsigned long m = ipnum_aip2l (mask);
	unsigned long n = ipnum_aip2l (net);
	unsigned long newn = n & m;
	return n == newn;
}
/*
	Edit a route configuration for a host or network (destination).

	Return 0 if edit is ok
	return 1 if the user wish to delete this route
	return -1 if the user escape from edit.
*/
PUBLIC int ROUTE::edit(RTTYPE route_type)
{
	int ret = -1;
	DIALOG dia;
	if (route_type == RTTYPE_ALTNET){
		static const char *tbinter[][2]={
			{"eth0",	MSG_R(F_FIRSTETH)},
			{"eth1",	MSG_R(F_SECOND)},
			{"eth2",	MSG_R(F_THIRD)},
			{"eth3",	MSG_R(F_FOURTH)},
		};
		FIELD_COMBO *comb = dia.newf_combo (MSG_U(F_INTERFACE,"Interface")
			,iface);
		for (int i=0; i<4; i++){
			comb->addopt (tbinter[i][0],tbinter[i][1]);
		}
		ip_gateway.setfrom ("*");
	}else{
		dia.newf_str (MSG_U(F_GATEWAY,"Gateway"),ip_gateway);
	}
	dia.last_noempty();
	int dst_field = dia.getnb();
	dia.newf_str (MSG_U(F_DEST,"Destination"),ip_dst);
	dia.last_noempty();
	int fld_netmask = dia.getnb();
	if (route_type != RTTYPE_HOST){
		FIELD_COMBO *comb = dia.newf_combo (MSG_R(F_NETMASK),netmask);
		host_setmasklist (comb);
	}
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit(MSG_U(T_ROUTESPEC,"route specification")
			,MSG_U(I_ROUTESPEC,"Enter either IP number or name\n")
			,help_routes
			,nof,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_DEL);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_DEL){
			ret = 1;
			break;
		}else if (code == MENU_ACCEPT){
			if (!ipnum_validip(ip_dst.get(),route_type == RTTYPE_HOST)){
				xconf_error (MSG_U(E_IVLDDST,"Invalid destination IP number"));
				nof = dst_field;
			}else if (route_type != RTTYPE_ALTNET
				&& !ipnum_validip(ip_gateway.get(),true)){
				xconf_error (MSG_U(E_IVLDGTW,"Invalid gateway IP number"));
				nof = 0;
			}else if (!netmask.is_empty()
				&& !ipnum_validip(netmask.get(),false)){
				xconf_error (MSG_U(E_IVLDMSK,"Invalid netmask"));
				nof = fld_netmask;
			}else if (route_type != RTTYPE_HOST
				&& !routes_validnet (ip_dst.get(),netmask.get())){
				xconf_error (MSG_U(E_IVLDNET
					,"The destination network is incompatible\n"
					 "the supplied netmask"));
				nof = dst_field;
			}else{
				ret = 0;
				break;
			}
		}
	}
	if (ret != 0) dia.restore();
	return ret;
}

