
/*
 Wineconf 1.2 - what means 'configurator for Wine' (oh, really?)
 by Daniel Mealha Cabrita (dancab@conectiva.com)
 May 8th, 2001
 */

/*
 history:
 1.0 - first version. present after 1.21. (sep 1st, 2000)
 1.01 - worked on 1.22 (nov 29th, 2000) -- present on LC 1.24r4
      - now lists (the drive list and the devices' list)
        are refreshed in a smarter way, so it flashes less
        and the previous selection is preserved.
 1.02 - bug, if you assigned an empty directory to a virtual
        drive wineconf segfaulted. fixed.
        version present in 1.24r8 (1.02 made in Feb 8th, 2001)
 1.1  - added support for users' config files (wineconf managed
        only the global configuration previously).
        version present in 1.25 (1.1 made in Mar 8th, 2001)
 1.2  - added support for standalone mode (wineconf being run
        directly from command line)
 */

#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "wineconf.h"
#include "wineconf.m"

#include "wineconf_main_window.cc"

MODULE_DEFINE_VERSION(wineconf);

PUBLIC MODULE_wineconf::MODULE_wineconf()
	: LINUXCONF_MODULE("wineconf")
{
	linuxconf_loadmsg ("wineconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_wineconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_MISCSERV){
		keymenu = MSG_U(M_wineconf,"Wine configuration");
		dia.new_menuitem ("wineconf","",keymenu);
	}
}

PUBLIC int MODULE_wineconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_MISCSERV){
		if (key == keymenu){
			// ### Place the call to the edit function here
                    start_things();
                }
	}
	return 0;
}


PUBLIC int MODULE_wineconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"wineconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain wineconf usage\n"
		 "\n"
		 "    wineconf --option ...\n")
		);
}

PUBLIC void MODULE_wineconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_wineconf::execmain (int argc , char *argv[], bool standalone)
{
        int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"wineconf")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
                    if(standalone){
                        start_as_standalone();
                    }else{
                        start_things();
                    }
                }else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_wineconf wineconf;

