#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif

class UUCP_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ UUCP_HELP_FILE */
public:
	UUCP_HELP_FILE (const char *fname);
	/*~PROTOEND~ UUCP_HELP_FILE */
};

class CONFIG_OBJ: public ARRAY_OBJ{
public:
	virtual void write (FILE_CFG *fout)=0;
	/*~PROTOBEG~ CONFIG_OBJ */
	/*~PROTOEND~ CONFIG_OBJ */
};

class CONFIG_OBJS: public ARRAY{
public:
	SSTRING first_comment;
	SSTRING last_comment;
	CONFIG_FILE &f;
	virtual CONFIG_OBJ *newobj (const char *, const SSTRING &, char *err)=0;
	/*~PROTOBEG~ CONFIG_OBJS */
public:
	CONFIG_OBJS (CONFIG_FILE&_f);
private:
	CONFIG_OBJ *getitem (int no);
public:
	int read (void);
	int write (void);
	/*~PROTOEND~ CONFIG_OBJS */
};

class POLL: public CONFIG_OBJ{
public:
	SSTRING comments;
	SSTRING system;
	SSTRING sched;
	/*~PROTOBEG~ POLL */
public:
	POLL (const POLL *p);
	POLL (const char *_system);
	POLL (const char *buf,
		 const SSTRING&_comments,
		 char *err);
	void write (FILE_CFG *fout);
	/*~PROTOEND~ POLL */
};

class POLLS: public CONFIG_OBJS{
	/*~PROTOBEG~ POLLS */
public:
	POLLS (void);
	void delsystem (const char *system);
	POLL *getitem (const char *system);
	POLL *getitem (int no);
protected:
	CONFIG_OBJ *newobj (const char *buf,
		 const SSTRING&_comments,
		 char *err);
public:
	/*~PROTOEND~ POLLS */
};

class PERMISSION: public CONFIG_OBJ{
public:
	SSTRING comments;
	SSTRING machine;
	SSTRING myname;
	SSTRING logname;
	SSTRING dirread;
	SSTRING dirwrite;
	SSTRING commands;
	char mayrequest;
	char maysend;
	/*~PROTOBEG~ PERMISSION */
public:
	PERMISSION (const PERMISSION *p);
	PERMISSION (const char *buf,
		 const SSTRING&_comments,
		 char *err);
	PERMISSION (void);
	void write (FILE_CFG *fout);
	/*~PROTOEND~ PERMISSION */
};


class PERMISSIONS: public CONFIG_OBJS{
	/*~PROTOBEG~ PERMISSIONS */
public:
	PERMISSIONS (void);
	void delsystem (const char *system);
	PERMISSION *getitem (const char *machine);
	PERMISSION *getitem (const char *machine,
		 int &no);
	PERMISSION *getitem (int no);
protected:
	CONFIG_OBJ *newobj (const char *buf,
		 const SSTRING&_comments,
		 char *err);
public:
	/*~PROTOEND~ PERMISSIONS */
};

struct CHAT_ELM{
	SSTRING expected;
	SSTRING send;
};

// How many expect/send pairs in the dialog
#define NBCHAT_ELM	6

class SYSTEM: public CONFIG_OBJ{
public:
	SSTRING name;
	SSTRING when;	// When are we allowed to call
	SSTRING phone;
	CHAT_ELM tbchat[NBCHAT_ELM];
	SSTRING acu;		// ACU or TCP
	int speed;		// Modem speed
	SSTRING comment;
	/*~PROTOBEG~ SYSTEM */
public:
	SYSTEM (const char *line,
		 const SSTRING&_comment,
		 char *err);
	SYSTEM (void);
	int edit (PERMISSIONS&perms, POLLS&polls);
	void write (FILE_CFG *fout);
	/*~PROTOEND~ SYSTEM */
};

class SYSTEMS: public CONFIG_OBJS{
	/*~PROTOBEG~ SYSTEMS */
public:
	SYSTEMS (void);
	int edit (PERMISSIONS&perms, POLLS&polls);
	SYSTEM *getitem (int no);
protected:
	CONFIG_OBJ *newobj (const char *buf,
		 const SSTRING&_comments,
		 char *err);
public:
	void sort (void);
	/*~PROTOEND~ SYSTEMS */
};

class DIALERS;

class DEVICE: public CONFIG_OBJ{
public:
	SSTRING comments;
	SSTRING acu;
	SSTRING device;
	SSTRING device2;	// Not sure what it is
	int speed;
	SSTRING type;		// Modem type from Dialer generally
	SSTRING options;
	/*~PROTOBEG~ DEVICE */
public:
	DEVICE (const char *buf,
		 const SSTRING&_comments,
		 char *err);
	DEVICE (void);
	int edit (const DIALERS&dial);
	void write (FILE_CFG *fout);
	/*~PROTOEND~ DEVICE */
};

class DEVICES: public CONFIG_OBJS{
	/*~PROTOBEG~ DEVICES */
public:
	DEVICES (void);
	int edit (void);
	DEVICE *getitem (int no);
protected:
	CONFIG_OBJ *newobj (const char *buf,
		 const SSTRING&_comments,
		 char *err);
public:
	void sort (void);
	/*~PROTOEND~ DEVICES */
};

class DIALER: public CONFIG_OBJ{
public:
	SSTRING comments;
	SSTRING type;
	SSTRING phonecnv;	// Special string for the phone number translation
	SSTRING chat;		// Dialing chat
	/*~PROTOBEG~ DIALER */
public:
	DIALER (const char *buf,
		 const SSTRING&_comments,
		 char *err);
	DIALER (void);
	void write (FILE_CFG *fout);
	/*~PROTOEND~ DIALER */
};

class DIALERS: public CONFIG_OBJS{
	/*~PROTOBEG~ DIALERS */
public:
	DIALERS (void);
	DIALER *getitem (const char *type)const;
	DIALER *getitem (int no)const;
protected:
	CONFIG_OBJ *newobj (const char *buf,
		 const SSTRING&_comments,
		 char *err);
public:
	/*~PROTOEND~ DIALERS */
};

extern const char subsys_uucp[];

#endif

