#include <string.h>
#include "usermenu.h"
#include "usermenu.m"
#include "../../main/main.h"

static HELP_FILE help_menu ("usermenu","usermenu");

const char K_USERMENU[]="usermenu";
static const char K_INDEX[]="index";
static const char K_ACCESSPRIV[]="accesspriv";

/*
	Get the access privilege mode (super user equivalence or simple access
	to the menu)
*/
bool usermenu_getaccesspriv (const char *menu)
{
	char key[100];
	snprintf (key,sizeof(key)-1,"%s.%s",menu,K_ACCESSPRIV);
	return linuxconf_getvalnum (K_USERMENU,key,0) != 0;
}

static void usermenu_editone (const char *menu)
{
	DIALOG dia;
	SSTRING name;
	name.setfrom (menu);
	dia.newf_str (MSG_U(F_MENUID,"Menu ID"),name);
	dia.last_noempty();
	SSTRING title;
	if (menu != NULL) title.setfrom (menuedit_gettitle(menu));
	dia.newf_str (MSG_U(F_MENUTITLE,"Menu title"),title);
	dia.last_noempty();
	SSTRINGS keys;
	SSTRINGS titles;
	SSTRINGS icons;
	linuxconf_gettree (keys,titles,icons);
	int nbmenu = titles.getnb();
	char tbsel[nbmenu];
	memset (tbsel,0,sizeof(tbsel));
	char accesspriv = 0;
	if (menu != NULL){
		char key[100];
		snprintf (key,sizeof(key)-1,"%s.opt",menu);
		SSTRINGS sels;
		linuxconf_getall (K_USERMENU,key,sels,0);
		for (int i=0; i<nbmenu; i++){
			if (sels.lookup(keys.getitem(i)->get())!=-1){
				tbsel[i] = 1;
			}
		}
		accesspriv = usermenu_getaccesspriv(menu) ? 1 : 0;
	}
	dia.newf_chk (MSG_U(F_ACCESSPRIV,"Access privilege"),accesspriv
		,MSG_U(I_ACCESSPRIV,"super user equivalence"));
	// Draw all menu options available in linuxconf
	dia.newf_title ("",MSG_U(I_OPTIONS,"Linuxconf's options"));
	for (int i=0; i<nbmenu; i++){
		char buf[100];
		snprintf (buf,sizeof(buf)-1,"%s %s"
			,keys.getitem(i)->get()
			,titles.getitem(i)->get());
		dia.newf_chk ("",tbsel[i],buf);
	}
	int nof=0;
	bool delrec = false;
	bool saverec = false;
	while (1){
		int opt = MENUBUT_CANCEL|MENUBUT_ACCEPT;
		if (menu != NULL) opt |= MENUBUT_DEL;
		MENU_STATUS code = dia.edit (MSG_U(T_ONEMENU,"One user menu")
			,MSG_U(I_ONEMENU
				,"Select the options you want to see\n"
				 "in your custom menu")
			,help_menu
			,nof,opt);
		if (code == MENU_CANCEL || code == MENU_CANCEL){
			break;
		}else if (code == MENU_DEL){
			if (xconf_delok()){
				delrec = true;
				break;
			}
		}else if (name.strchr(' ')!=NULL){
			xconf_error (MSG_U(E_NOSPACE,"No space in menu ID"));
			nof = 0;
		}else{
			if (menu != NULL) delrec = true;
			saverec = true;
			break;
		}
	}
	SSTRINGS tb;
	linuxconf_getall (K_USERMENU,K_INDEX,tb,1);
	if (delrec){
		char key[100];
		snprintf (key,sizeof(key)-1,"%s.opt",menu);
		linuxconf_removeall (K_USERMENU,key);
		snprintf (key,sizeof(key)-1,"%s.title",menu);
		linuxconf_removeall (K_USERMENU,key);
		int pos = tb.lookup (menu);
		if (pos != -1){
			tb.remove_del (pos);
		}
		snprintf (key,sizeof(key)-1,"%s.accesspriv",menu);
		linuxconf_removeall (K_USERMENU,key);
	}
	if (saverec){
		menu = name.get();
		char key[100];
		snprintf (key,sizeof(key)-1,"%s.opt",menu);
		int pos = tb.lookup (menu);
		if (pos == -1){
			tb.add (new SSTRING (menu));
		}
		for (int i=0; i<nbmenu; i++){
			if (tbsel[i]){
				linuxconf_add (K_USERMENU,key,keys.getitem(i)->get());
			}
		}
		snprintf (key,sizeof(key)-1,"%s.title",menu);
		linuxconf_replace (K_USERMENU,key,title);
		snprintf (key,sizeof(key)-1,"%s.accesspriv",menu);
		linuxconf_replace (K_USERMENU,key,accesspriv);
	}
	if (delrec || saverec){
		linuxconf_replace (K_USERMENU,K_INDEX,tb);
		linuxconf_save();
	}
}
/*
	Get the list of all user defined menus
	Return the number of menus defined.
*/
int menuedit_getlist(SSTRINGS &tb)
{
	return linuxconf_getall (K_USERMENU,K_INDEX,tb,0);
}


/*
	Get the title of a menu
*/
const char *menuedit_gettitle(const char *menuname)
{
	char key[100];
	snprintf (key,sizeof(key)-1,"%s.title",menuname);
	return linuxconf_getval (K_USERMENU,key,"-");
}

void usermenu_edit()
{
	int nof = 0;
	DIALOG_LISTE dia;
	dia.newf_head ("",MSG_U(H_USERMENU,"Id\tTitle"));
	dia.addwhat (MSG_U(I_NEWMENU,"Select [Add] to define a new menu"));
	while (1){
		SSTRINGS tb;
		int n = menuedit_getlist(tb);
		tb.sort();
		for (int i=0; i<n; i++){
			const char *menu = tb.getitem(i)->get();
			dia.set_menuitem(i,menu,menuedit_gettitle(menu));
		}
		dia.remove_last (n+1);
		MENU_STATUS code = dia.editmenu(MSG_U(T_USERMENUS
			,"User defined menus")
			,MSG_U(I_USERMENUS
				,"Here is the list of user defined menus")
			,help_menu
			,nof,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			usermenu_editone (NULL);
		}else if (nof >=0 && nof < n){
			usermenu_editone (tb.getitem(nof)->get());
		}
		show_resetpriv();
	}
}

