/* ***********

	RARP server configuration

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "rarp.h"
#include "rarp.m"
#include <netconf.h>

MODULE_DEFINE_VERSION(rarp);

PUBLIC MODULE_rarp::MODULE_rarp()
	: LINUXCONF_MODULE("rarp")
{
	linuxconf_loadmsg ("rarp",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_rarp::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_BOOT){
		keymenu = MSG_U(M_rarp,"RARP service");
		dia.new_menuitem ("rarp","",keymenu);
	}
}

PUBLIC int MODULE_rarp::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_BOOT){
		if (key == keymenu){
			rarp_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_rarp::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"rarp")==0){
		ret = 0;
	}
	return ret;
}


PUBLIC int MODULE_rarp::probe (
	int level,
	int ,
	bool)
{
	if (level == 2){
		net_title (MSG_U(S_RARP,"Setting RARP service"));
		rarp_activate ();
	}
	return 0;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module rarp\n"
		 "linuxconf --modulemain rarp [ specific options ]\n"
		 "\n"
		 "    No command line option\n"
		 "\n")
		);
}

PUBLIC int MODULE_rarp::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"rarp")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_rarp rarp;

