
/* this configuration deals with the 'clients' file */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "radiusconf.h"
#include "radiusconf.m"

#include "rc_parser.h"
#include "rc_tools.h"

void edit_client_entry(VIEWITEMS &given_vitems, int which_one)
{
    DIALOG      my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;
    SSTRING     dialog_title;

    /* loads vars.. */
    /* builds gui.. */
    EASY_STR2(clientname,0,MSG_U(F_HOSTNAMEORIP,"Host name (or IP):"));
    EASY_STR2(assignedkey,1,MSG_U(F_ENCRYPTIONKEY,"Encryption key:"));

    while(1){
        /* opens dialog.. */
        dialog_title.setfromf(MSG_U(T_CLIENTENTRY,"Client entry %d"), which_one+1);
        my_selection=0;
        my_button=my_dialog.editmenu(dialog_title.get(), "", hf_clients, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ACCEPT:
            {
                /* save vars.. */
                SSTRING my_line;

                if((invalid_entry(clientname.get()))||(invalid_entry(assignedkey.get()))){
                    informative_window(MSG_U(T_INVALIDENTRY,"Invalid entry"), MSG_U(E_INVALIDENTRY,"None of these fields may be left empty\nneither have space characters."));
                }else{
                    my_line.setfromf("%s\t%s", clientname.get(), assignedkey.get());
                    given_vitems.getitem(which_one)->line.setfrom(my_line);
                    given_vitems.write(cf_clients, 0);
                    return;
                }
            }
            break;
        case MENU_DEL:
            /* remove this entry */
            given_vitems.remove_del(which_one);
            given_vitems.write(cf_clients, 0);
            return;
            break;
        default:
            break;
        }
    }

}

void show_clients_list(void)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    VIEWITEMS_PARSER my_vitems_parser;
    VIEWITEMS my_vitems(my_vitems_parser);

    my_vitems.read(cf_clients);

    my_dialog.newf_head("", MSG_U(F_HOSTNAMEHEAD,"Host name"));

    while(1){
        int         progressive_counter=0,
                    regressive_counter;
        SSTRING     primary_entry;

        /* fills list.. */
        regressive_counter=my_vitems.getnb();
        while(regressive_counter--){
            gimme_word_from_string(my_vitems.getitem(progressive_counter)->line.get(), primary_entry, 0);
            my_dialog.set_menuitem(progressive_counter, primary_entry.get(), "");
            progressive_counter++;
        }

        // remove entries below (they're the previous ones and useless now)
        my_dialog.remove_last(progressive_counter+1);

        my_button=my_dialog.editmenu(MSG_U(T_LISTOFCLIENTS,"List of clients"), MSG_U(I_LISTOFCLIENTS,"This is a list of clients which are allowed\nto make authentication requests\nand their encryption keys."), hf_general_list, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            {
                int how_many;

                how_many=my_vitems.getnb();
                my_vitems.add(new VIEWITEM(MSG_U(X_NEWENTRY_JUSTADDED,"new_entry.just_added")));
                edit_client_entry(my_vitems, how_many);
                my_vitems.write(cf_clients, 0);
            }
            break;
        default:
            edit_client_entry(my_vitems, my_selection);
            break;
        }
    }







}

