#include <Python.h>
#include <dialog.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

/* LCFieldString */

static PyObject *
LCFieldString_set(LCFieldStringObject *self, PyObject *args)
{
	char *s;
	if (!PyArg_ParseTuple(args,"s",&s))
		return NULL;
	self->value->setfrom(s);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
LCFieldString_get(LCFieldStringObject *self, PyObject *args)
{
	return PyString_FromString(self->value->get());
}

static struct PyMethodDef LCFieldString_methods[] = {
	{"set", (binaryfunc) LCFieldString_set, 1},
	{"get", (binaryfunc) LCFieldString_get, 1},
	{NULL, NULL}
};

static void
LCFieldString_dealloc(LCFieldStringObject *self)
{
	delete self->value;
	PyMem_DEL(self);
}

static PyObject *
LCFieldString_getattr(LCFieldStringObject *self, char *name)
{
	return Py_FindMethod(LCFieldString_methods, (PyObject*) self, name);
}

static PyObject *
LCFieldString_repr(LCFieldStringObject *self)
{
	return PyString_FromString(self->value->get());
}

PyTypeObject LCFieldString_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCFieldString",
	sizeof(LCFieldStringObject),
	0,
	(destructor) LCFieldString_dealloc,
	(printfunc) 0,
	(getattrfunc) LCFieldString_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) LCFieldString_repr,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCFieldString_New(const char *prompt, SSTRING *value)
{
	LCFieldStringObject *self;
	self = PyObject_NEW(LCFieldStringObject, &LCFieldString_Type);
	if (self == NULL)
		return NULL;
	self->prompt = prompt;
	self->value = value;
	return (PyObject*) self;
}

const char *LCFieldString_Prompt(PyObject *field)
{
	if (!LCFieldString_Check(field))
		return NULL;
	return ((LCFieldStringObject*)field)->prompt;
}

SSTRING *LCFieldString_Value(PyObject *field)
{
	if (!LCFieldString_Check(field))
		return NULL;
	return ((LCFieldStringObject*)field)->value;
}

/* LCFieldCombo */

PyObject *
LCFieldCombo_addopt(LCFieldComboObject *self, PyObject *args)
{
	char *value, *verbose="";
	if(!PyArg_ParseTuple(args,"s|s",&value,&verbose))
		return NULL;
	self->combo->addopt(value,verbose);
	Py_INCREF(Py_None);
	return Py_None;
}

PyObject *
LCFieldCombo_addopts(LCFieldComboObject *self, PyObject *args)
{
	PyObject *l;
	if (!PyArg_ParseTuple(args,"O",&l))
		return NULL;
	if (!PyList_Check(l))
		return NULL;
	int size = PyList_Size(l);
	for (int i = 0; i != size; i++) {
		char *value, *verbose="";
		PyObject *o = PyList_GetItem(l,i);
		if(!PyArg_ParseTuple(o,"s|s",&value,&verbose))
			return NULL;
		self->combo->addopt(value,verbose);
	}
	Py_INCREF(Py_None);
	return Py_None;
}

/* LCFieldCombo "inherits" LCFieldString. */
static struct PyMethodDef LCFieldCombo_methods[] = {
	{"set", (binaryfunc) LCFieldString_set, 1},
	{"get", (binaryfunc) LCFieldString_get, 1},
	{"addopt", (binaryfunc) LCFieldCombo_addopt, 1},
	{"addopts", (binaryfunc) LCFieldCombo_addopts, 1},
	{NULL, NULL}
};

static PyObject *
LCFieldCombo_getattr(LCFieldComboObject *self, char *name)
{
	return Py_FindMethod(LCFieldCombo_methods, (PyObject*) self, name);
}

/* Again, LCFieldCombo "inherits" LCFieldString, so this is ok. */
PyTypeObject LCFieldCombo_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCFieldCombo",
	sizeof(LCFieldComboObject),
	0,
	(destructor) LCFieldString_dealloc,
	(printfunc) 0,
	(getattrfunc) LCFieldCombo_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) LCFieldString_repr,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCFieldCombo_New(M_FIELD_COMBO *combo, const char *prompt, SSTRING *value)
{
	LCFieldComboObject *self;
	self = PyObject_NEW(LCFieldComboObject, &LCFieldCombo_Type);
	if (self == NULL)
		return NULL;
	self->combo = combo;
	((LCFieldStringObject*)self)->prompt = prompt;
	((LCFieldStringObject*)self)->value = value;
	return (PyObject*) self;
}

const char *LCFieldCombo_Prompt(PyObject *field)
{
	if (!LCFieldCombo_Check(field))
		return NULL;
	return ((LCFieldStringObject*)field)->prompt;
}

SSTRING *LCFieldCombo_Value(PyObject *field)
{
	if (!LCFieldCombo_Check(field))
		return NULL;
	return ((LCFieldStringObject*)field)->value;
}

M_FIELD_COMBO *LCFieldCombo_Combo(PyObject *field)
{
	if (!LCFieldCombo_Check(field))
		return NULL;
	return ((LCFieldComboObject*)field)->combo;
}	

/* LCFieldRadio */

static PyObject *
LCFieldRadio_set(LCFieldRadioObject *self, PyObject *args)
{
	int i;
	if (!PyArg_ParseTuple(args,"i",&i))
		return NULL;
	*self->value = (char) i;
	Py_INCREF(Py_None);
	return Py_None;
}

PyObject *
LCFieldRadio_get(LCFieldRadioObject *self, PyObject *args)
{
	return PyInt_FromLong((long)*self->value);
}

PyObject *
LCFieldRadio_addopt(LCFieldRadioObject *self, PyObject *args)
{
	char *prompt, *title;
	int instance;
	if(!PyArg_ParseTuple(args,"sis",&prompt, &instance, &title))
		return NULL;
	self->dia->newf_radio(prompt, *self->value, instance, title);
	Py_INCREF(Py_None);
	return Py_None;
}

PyObject *
LCFieldRadio_addopts(LCFieldRadioObject *self, PyObject *args)
{
	PyObject *l;
	if (!PyArg_ParseTuple(args,"O",&l))
		return NULL;
	if (!PyList_Check(l))
		return NULL;
	int size = PyList_Size(l);
	for (int i = 0; i != size; i++) {
		char *prompt, *title;
		int instance;
		PyObject *o = PyList_GetItem(l,i);
		if(!PyArg_ParseTuple(o,"sis",&prompt, &instance, &title))
			return NULL;
		self->dia->newf_radio(prompt, *self->value, instance, title);
	}
	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef LCFieldRadio_methods[] = {
	{"set", (binaryfunc) LCFieldRadio_set, 1},
	{"get", (binaryfunc) LCFieldRadio_get, 1},
	{"addopt", (binaryfunc) LCFieldRadio_addopt, 1},
	{"addopts", (binaryfunc) LCFieldRadio_addopts, 1},
	{NULL, NULL}
};

static void
LCFieldRadio_dealloc(LCFieldRadioObject *self)
{
	free(self->value);
	PyMem_DEL(self);
}

static PyObject *
LCFieldRadio_getattr(LCFieldRadioObject *self, char *name)
{
	return Py_FindMethod(LCFieldRadio_methods, (PyObject*) self, name);
}

static PyObject *
LCFieldRadio_repr(LCFieldRadioObject *self)
{
	char tmp[4];
	sprintf(tmp,"%d",(int)*self->value);
	return PyString_FromString(tmp);
}

PyTypeObject LCFieldRadio_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCFieldRadio",
	sizeof(LCFieldRadioObject),
	0,
	(destructor) LCFieldRadio_dealloc,
	(printfunc) 0,
	(getattrfunc) LCFieldRadio_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) LCFieldRadio_repr,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCFieldRadio_New(char *prompt, char *value, DIALOG *dia)
{
	LCFieldRadioObject *self;
	self = PyObject_NEW(LCFieldRadioObject, &LCFieldRadio_Type);
	if (self == NULL)
		return NULL;
	self->prompt = prompt;
	self->value = value;
	self->dia = dia;
	return (PyObject*) self;
}

const char *LCFieldRadio_Prompt(PyObject *field)
{
	if (!LCFieldRadio_Check(field))
		return NULL;
	return ((LCFieldRadioObject*)field)->prompt;
}

char *LCFieldRadio_Value(PyObject *field)
{
	if (!LCFieldRadio_Check(field))
		return NULL;
	return ((LCFieldRadioObject*)field)->value;
}

/* LCFieldNumber */

static PyObject *
LCFieldNumber_set(LCFieldNumberObject *self, PyObject *args)
{
	int i;
	if (!PyArg_ParseTuple(args,"i",&i))
		return NULL;
	*self->value = i;
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
LCFieldNumber_get(LCFieldNumberObject *self, PyObject *args)
{
	return PyInt_FromLong((long)*self->value);
}

static struct PyMethodDef LCFieldNumber_methods[] = {
	{"set", (binaryfunc) LCFieldNumber_set, 1},
	{"get", (binaryfunc) LCFieldNumber_get, 1},
	{NULL, NULL}
};

static void
LCFieldNumber_dealloc(LCFieldNumberObject *self)
{
	delete self->value;
	PyMem_DEL(self);
}

static PyObject *
LCFieldNumber_getattr(LCFieldNumberObject *self, char *name)
{
	return Py_FindMethod(LCFieldNumber_methods, (PyObject*) self, name);
}

static PyObject *
LCFieldNumber_repr(LCFieldNumberObject *self)
{
	char tmp[16];
	sprintf(tmp,"%d",*self->value);
	return PyString_FromString(tmp);
}

PyTypeObject LCFieldNumber_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCFieldNumber",
	sizeof(LCFieldNumberObject),
	0,
	(destructor) LCFieldNumber_dealloc,
	(printfunc) 0,
	(getattrfunc) LCFieldNumber_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) LCFieldNumber_repr,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCFieldNumber_New(const char *prompt, int *value)
{
	LCFieldNumberObject *self;
	self = PyObject_NEW(LCFieldNumberObject, &LCFieldNumber_Type);
	if (self == NULL)
		return NULL;
	self->prompt = prompt;
	self->value = value;
	return (PyObject*) self;
}

const char *LCFieldNumber_Prompt(PyObject *field)
{
	if (!LCFieldNumber_Check(field))
		return NULL;
	return ((LCFieldNumberObject*)field)->prompt;
}

int *LCFieldNumber_Value(PyObject *field)
{
	if (!LCFieldNumber_Check(field))
		return NULL;
	return ((LCFieldNumberObject*)field)->value;
}

/* LCFieldCheck */

static PyObject *
LCFieldCheck_set(LCFieldCheckObject *self, PyObject *args)
{
	char i;
	if (!PyArg_ParseTuple(args,"i",&i))
		return NULL;
	*self->value = i;
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
LCFieldCheck_get(LCFieldCheckObject *self, PyObject *args)
{
	return PyInt_FromLong((long)*self->value);
}

static struct PyMethodDef LCFieldCheck_methods[] = {
	{"set", (binaryfunc) LCFieldCheck_set, 1},
	{"get", (binaryfunc) LCFieldCheck_get, 1},
	{NULL, NULL}
};

static void
LCFieldCheck_dealloc(LCFieldCheckObject *self)
{
	delete self->value;
	PyMem_DEL(self);
}

static PyObject *
LCFieldCheck_getattr(LCFieldCheckObject *self, char *name)
{
	return Py_FindMethod(LCFieldCheck_methods, (PyObject*) self, name);
}

static PyObject *
LCFieldCheck_repr(LCFieldCheckObject *self)
{
	char tmp[16];
	sprintf(tmp,"%d",*self->value);
	return PyString_FromString(tmp);
}

PyTypeObject LCFieldCheck_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCFieldCheck",
	sizeof(LCFieldCheckObject),
	0,
	(destructor) LCFieldCheck_dealloc,
	(printfunc) 0,
	(getattrfunc) LCFieldCheck_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) LCFieldCheck_repr,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCFieldCheck_New(const char *prompt, char *value)
{
	LCFieldCheckObject *self;
	self = PyObject_NEW(LCFieldCheckObject, &LCFieldCheck_Type);
	if (self == NULL)
		return NULL;
	self->prompt = prompt;
	self->value = value;
	return (PyObject*) self;
}

const char *LCFieldCheck_Prompt(PyObject *field)
{
	if (!LCFieldCheck_Check(field))
		return NULL;
	return ((LCFieldCheckObject*)field)->prompt;
}

char *LCFieldCheck_Value(PyObject *field)
{
	if (!LCFieldCheck_Check(field))
		return NULL;
	return ((LCFieldCheckObject*)field)->value;
}

/* LCFieldCheckStr */

static PyObject *
LCFieldCheckStr_set_str(LCFieldCheckStrObject *self, PyObject *args)
{
	char *s;
	if (!PyArg_ParseTuple(args,"i",&s))
		return NULL;
	self->value_str->setfrom(s);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
LCFieldCheckStr_get_str(LCFieldCheckStrObject *self, PyObject *args)
{
	return PyString_FromString(self->value_str->get());
}

static struct PyMethodDef LCFieldCheckStr_methods[] = {
	{"set", (binaryfunc) LCFieldNumber_set, 1},
	{"get", (binaryfunc) LCFieldNumber_get, 1},
	{"set_str", (binaryfunc) LCFieldCheckStr_set_str, 1},
	{"get_str", (binaryfunc) LCFieldCheckStr_get_str, 1},
	{NULL, NULL}
};

static void
LCFieldCheckStr_dealloc(LCFieldCheckStrObject *self)
{
	delete ((LCFieldNumberObject*)self)->value;
	delete self->value_str;
	PyMem_DEL(self);
}

static PyObject *
LCFieldCheckStr_getattr(LCFieldCheckStrObject *self, char *name)
{
	return Py_FindMethod(LCFieldCheckStr_methods, (PyObject*) self, name);
}

PyTypeObject LCFieldCheckStr_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCFieldCheckStr",
	sizeof(LCFieldCheckStrObject),
	0,
	(destructor) LCFieldCheckStr_dealloc,
	(printfunc) 0,
	(getattrfunc) LCFieldCheckStr_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) LCFieldNumber_repr,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCFieldCheckStr_New(const char *prompt, int *value, SSTRING *value_str)
{
	LCFieldCheckStrObject *self;
	self = PyObject_NEW(LCFieldCheckStrObject, &LCFieldCheckStr_Type);
	if (self == NULL)
		return NULL;
	((LCFieldNumberObject*)self)->prompt = prompt;
	((LCFieldNumberObject*)self)->value = value;
	self->value_str = value_str;
	return (PyObject*) self;
}

const char *LCFieldCheckStr_Prompt(PyObject *field)
{
	if (!LCFieldCheckStr_Check(field))
		return NULL;
	return ((LCFieldNumberObject*)field)->prompt;
}

int *LCFieldCheckStr_Value(PyObject *field)
{
	if (!LCFieldCheckStr_Check(field))
		return NULL;
	return ((LCFieldNumberObject*)field)->value;
}

SSTRING *LCFieldCheckStr_ValueStr(PyObject *field)
{
	if (!LCFieldCheckStr_Check(field))
		return NULL;
	return ((LCFieldCheckStrObject*)field)->value_str;
}

/* LCFieldButton */

PyObject *
LCFieldButton_test(LCFieldButtonObject *self, PyObject *args)
{
	return PyInt_FromLong((long)dialog_testmessage(*self->msg));
}

static struct PyMethodDef LCFieldButton_methods[] = {
	{"test", (binaryfunc) LCFieldButton_test, 1},
	{NULL, NULL}
};

static void
LCFieldButton_dealloc(LCFieldButtonObject *self)
{
	delete self->msg;
	PyMem_DEL(self);
}

static PyObject *
LCFieldButton_getattr(LCFieldButtonObject *self, char *name)
{
	return Py_FindMethod(LCFieldButton_methods, (PyObject*) self, name);
}

PyTypeObject LCFieldButton_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCFieldButton",
	sizeof(LCFieldButtonObject),
	0,
	(destructor) LCFieldButton_dealloc,
	(printfunc) 0,
	(getattrfunc) LCFieldButton_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) 0,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCFieldButton_New(PRIVATE_MESSAGE *msg)
{
	LCFieldButtonObject *self;
	self = PyObject_NEW(LCFieldButtonObject, &LCFieldButton_Type);
	if (self == NULL)
		return NULL;
	self->msg = msg;
	return (PyObject*) self;
}

/* ----------------------- */

static struct PyMethodDef lcfield_methods[] = {
	{NULL,NULL}
};

extern "C" void
initlcfield()
{
	PyObject *m, *d;
	m = Py_InitModule("lcfield", lcfield_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "lcfield.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcfield");
}
