
#ifndef PRINTER_FI_PRS

#include <modapi.h>
#include <sys/stat.h>
#include "printer_common_data.h"

#define ps_gsdevice         ps_cfg[0].d
#define ps_resolution       ps_cfg[1].d
#define ps_color            ps_cfg[2].d
#define ps_papersize        ps_cfg[3].d
#define ps_extra_gs_options ps_cfg[4].d
#define ps_reverse_order    ps_cfg[5].d
#define ps_send_eof         ps_cfg[6].d
#define ps_nup              ps_cfg[7].d
#define ps_rtlftmar         ps_cfg[8].d
#define ps_topbotmar        ps_cfg[9].d

#define to_textonlyoptions  to_cfg[0].d
#define to_crlftrans        to_cfg[1].d
#define to_text_send_eof    to_cfg[2].d

#define ge_desired_to       ge_cfg[0].d
#define ge_papersize        ge_cfg[1].d
#define ge_printer_type     ge_cfg[2].d
#define ge_ascii_to_ps      ge_cfg[3].d

struct t_rh_array{
    char d[TYPICAL_STRING_SIZE];
};

extern struct t_rh_array ps_cfg[];
extern struct t_rh_array to_cfg[];
extern struct t_rh_array ge_cfg[];

extern char f_printername[];

extern char f_filterdescription[];
extern SSTRING f_resolution;
extern SSTRING f_papersize;
extern SSTRING f_colordepth;
extern char f_sendeof;
extern char f_correctcrlf;
extern char f_fastascii;
extern SSTRING f_printedpages;
extern int f_horizmargins;
extern int f_vertmargins;
extern char f_extragsopt[];


/* protos */
void write_filter_description(int which_printer, const char *given_desc);
const char *read_filter_description(int which_printer);
void remove_filter_description(int which_printer);
void create_commented_printcap_config(char *output_string);
void sort_string_list(char *given_string_list);
char *gimme_next_string(const char *from_this_point);
char *return_filter_propertylist(char *which_printer, char *which_property);
char *return_filters_list(void);
void save_rhprt_config(char *my_parms, struct t_rh_array *where_to_go, char *printer_spool_path, int add_export);
int load_rhprt_config(char *my_parms, struct t_rh_array *where_to_go, char *printer_spool_path);
void load_initialise_secondary_configfiles(int which_printer);
void save_all_the_filters_stuff(int which_printer);
void tellme_which_printer_it_is(char *given_gsdriver, char *given_colordepth, char *output_string);
void tellme_fully_which_printer_it_is(char *given_gsdriver, char *given_colordepth, char *output_string, char *secondary_output);
void gimme_string_element(char *given_string, int which_element, char *output_string);
void load_to_gui_variables(void);
void save_from_gui_variables(void);

void save_all_printers_data(void);

void load_printcap(void);
void realloc_buffers_of_mine(void);
void free_buffers_of_mine(void);
int is_this_printer_there(const char *given_printername, const char *given_printerlist);
int is_printcap_lprng_style(void);
int return_lpr_system_installed_in_this_system(void);

void new_filter_so_reset_some_things(char *overrider_printer);
int populate_sstrings(char *filter_id, char *field_identificator, int processing, SSTRINGS &descriptions, SSTRINGS &values);

int translate_printer_number(int given_number);
int return_virtual_printer_number(int given_number);
int returns_free_slot(void);
int create_printer_files(char *printer_name_full_path);
int create_a_printer(char type_printr, char *printer_name, char *my_fullspoolpath);
void remove_printer(int which_printer);

#define PRINTER_FI_PRS
#endif
