// vim: nowrap

#include "postfixconf.h"
#include "postfixconf.m"

/*
DESCRIPTION: This DIALOG contains settings of Postfix configuration options that control delivery rates
RETURN: 0 - case the user accept the changes
        1 - case the user cancel the changes
*/
PUBLIC int MODULE_postfixconf::ctrldelivrates_edit(DATAMAIN &data){
	int ret = 0;
	int nof = 0;
	DIALOG dia;
	SSTRING *st;
	
	// initial_destination_concurrency
	st = data.getvarvariable(V_INITIAL_DESTINATION_CONCURRENCY);
	int val_initdestconc = st->getval();
	dia.newf_num (MSG_U(F_INITDESTCONC,"Initial destination concurrency"), val_initdestconc);

	// maximal_backoff_time
	st = data.getvarvariable(V_MAXIMAL_BACKOFF_TIME);
	int val_maxbackofftime = st->getval();
	dia.newf_num (MSG_U(F_MAXBACKOFFTIME,"Maximal backoff time"), val_maxbackofftime);
	
	// maximal_queue_lifetime
	st = data.getvarvariable(V_MAXIMAL_QUEUE_LIFETIME);
	int val_maxqueueliftime = st->getval();
	dia.newf_num (MSG_U(F_MAXQUEUELIFETIME,"Maximal queue lifetime"), val_maxqueueliftime);
	
	// minimal_backoff_time
	st = data.getvarvariable(V_MINIMAL_BACKOFF_TIME);
	int val_minbackofftime = st->getval();
	dia.newf_num (MSG_U(F_MINBACKOFFTIME,"Minimal backoff time"), val_minbackofftime);
	
	// queue_run_delay
	st = data.getvarvariable(V_QUEUE_RUN_DELAY);
	int val_queuerundelay = st->getval();
	dia.newf_num (MSG_U(F_QUEUERUNDELAY,"Queue run delay"), val_queuerundelay);

	// defer_transports
	st = data.getvarvariable(V_DEFER_TRANSPORTS);
	dia.newf_str(MSG_U(F_DEFERTRANS,"Defer transports"),*st);

	dia.setbutinfo (MENU_USR1, MSG_R(B_SETTODEFAULT), MSG_R(B_SETTODEFAULT));
	
	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_CTRLDELIVRATES,"Control delivery rates")
			,MSG_U(I_CTRLDELIVRATES,"Here you can configure postfix options that control delivery rates")
			,help_postfix_ctrldelivrates
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_USR1);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			// validations
			
			// initial_destination_concurrency
			data.getvarvariable(V_INITIAL_DESTINATION_CONCURRENCY)->setfrom(val_initdestconc);
			
			// maximal_backoff_time
			data.getvarvariable(V_MAXIMAL_BACKOFF_TIME)->setfrom(val_maxbackofftime);
			
			// maximal_queue_lifetime
			data.getvarvariable(V_MAXIMAL_QUEUE_LIFETIME)->setfrom(val_maxqueueliftime);

			// minimal_backoff_time
			data.getvarvariable(V_MINIMAL_BACKOFF_TIME)->setfrom(val_minbackofftime);
		
			// queue_run_delay
			data.getvarvariable(V_QUEUE_RUN_DELAY)->setfrom(val_queuerundelay);
			
			ret = 1;
			break;
		}else if (code == MENU_USR1){
			if ( dialog_yesno(MSG_R(T_RESTORETODEFAULT)
					 ,MSG_R(N_RESTORETODEFAULT)
					 ,help_postfix_basic) == MENU_YES ){
				int values[]={
						V_INITIAL_DESTINATION_CONCURRENCY,
						V_MAXIMAL_BACKOFF_TIME,
						V_MAXIMAL_QUEUE_LIFETIME,
						V_MINIMAL_BACKOFF_TIME,
						V_QUEUE_RUN_DELAY,
						V_DEFER_TRANSPORTS,
						-1
				};
				data.setdefaultvarvalues(values);
				
				// initial_destination_concurrency
				st = data.getvarvariable(V_INITIAL_DESTINATION_CONCURRENCY);
				val_initdestconc = st->getval();

				// maximal_backoff_time
				st = data.getvarvariable(V_MAXIMAL_BACKOFF_TIME);
				val_maxbackofftime = st->getval();
				
				// maximal_queue_lifetime
				st = data.getvarvariable(V_MAXIMAL_QUEUE_LIFETIME);
				val_maxqueueliftime = st->getval();
				
				// minimal_backoff_time
				st = data.getvarvariable(V_MINIMAL_BACKOFF_TIME);
				val_minbackofftime = st->getval();
				
				// queue_run_delay
				st = data.getvarvariable(V_QUEUE_RUN_DELAY);
				val_queuerundelay = st->getval();

				dia.reload();
			}
		}
	}
	return ret;
}
