/* manages the /etc/security/limits.conf file */

/* this limits.conf configurador should be presented in a better manner..
   ..one day */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "pamconf.h"
#include "pamconf.m"
#include "pamconf_tools.h"
#include "fviews.h"

void line_properties_limits(int which_line, VIEWITEMS &given_vitems)
{
    DIALOG my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    SSTRING     title_text;
    SSTRING     *current_line;

    FIELD_LIST  *fl_type, *fl_item;
    SSTRING     domain, type, item;
    SSTRING     value_str;
    int         value;

    int         spaces_present; /* !=0 if there are space characters in some entry */

    current_line=&(given_vitems.getitem(which_line)->line);
    title_text.setfromf(MSG_U(T_LIMENTRYNFORLIMS, "Entry #%d for limits definitions"), which_line+1);

    /* load vars */
    gimme_word_from_string(current_line->get(), domain, 0);
    gimme_word_from_string(current_line->get(), type, 1);
    gimme_word_from_string(current_line->get(), item, 2);
    gimme_word_from_string(current_line->get(), value_str, 3);
    value=atoi(value_str.get());

    /* builds gui */
    my_dialog.newf_str(MSG_U(F_LIMDOMAIN, "Domain:"), domain);
    fl_type=my_dialog.newf_list(MSG_U(F_LIMTYPE, "Type:"), type);
    fl_type->addopt("hard", MSG_U(X_LIMHARD, "Hard"), "");
    fl_type->addopt("soft", MSG_U(X_LIMSOFT, "Soft"), "");
    fl_type->addopt("-", MSG_U(X_LIMNONE, "None"), "");
    fl_item=my_dialog.newf_list(MSG_U(F_LIMLIMITS, "Limits:"), item);
    fl_item->addopt("core", MSG_U(X_LIMCORESIZE, "Core file size (KB)"), "");
    fl_item->addopt("data", MSG_U(X_LIMMAXDATASIZE, "Max. data size (KB)"), "");
    fl_item->addopt("fsize", MSG_U(X_LIMMAXFILESIZE, "Max. file size (KB)"), "");
    fl_item->addopt("memlock", MSG_U(X_LIMMAXLOCKINADDRS, "Max. locked-in-mem address space (KB)"), "");
    fl_item->addopt("nofile", MSG_U(X_LIMMAXNUMBOPENFILS, "Max. number of open files"), "");
    fl_item->addopt("rss", MSG_U(X_LIMMAXRESSETSIZE, "Max. resident set size (KB)"), "");
    fl_item->addopt("stack", MSG_U(X_LIMMAXSTACKSZ, "Max. stack size (KB)"), "");
    fl_item->addopt("cpu", MSG_U(X_LIMMAXCPUTIME, "Max. CPU time (min)"), "");
    fl_item->addopt("nproc", MSG_U(X_LIMMAXNUMBPROC, "Max. number of processes"), "");
    fl_item->addopt("as", MSG_U(X_LIMADDSPACELIM, "Address space limit"), "");
    fl_item->addopt("maxlogins", MSG_U(X_LIMMAXLOGNSUSER, "Max. logins for this user"), "");
    fl_item->addopt("priority", MSG_U(X_LIMPRIORRUNUSRPROC, "Priority to run user process"), "");
    my_dialog.newf_num(MSG_U(F_LIMTO, "To:"), value);

    while(1){
        spaces_present=0;

        /* opens dialog.. */
        my_selection=0;
        my_button=my_dialog.editmenu(title_text.get(), "", hf_pam_limits, my_selection, MENUBUT_QUIT|MENUBUT_DEL|MENUBUT_ACCEPT);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_DEL:
            if(confirm_yesno_window(MSG_U(T_LIMENTRYREMOV, "Entry removal"), MSG_U(I_LIMENTRYREMOV, "Do you really want\nto remove this definition?"))){
                given_vitems.remove_del(which_line);
                given_vitems.write(cf_limits, NULL);
                return;
            }
            break;
        case MENU_ACCEPT:
            /* check for spaces in fields which don't tolerate spaces */
            SPA(domain);

            if(spaces_present){
                spaces_not_allowed();
            }else{
                current_line->setfrom(domain);
                adjust_spaces_to(*current_line, 16);
                current_line->append(type.get());
                adjust_spaces_to(*current_line, 24);
                current_line->append(item.get());
                adjust_spaces_to(*current_line, 40);
                value_str.setfromf("%d", value);
                current_line->append(value_str.get());

                /* writes to file */
                given_vitems.write(cf_limits, NULL);

                return;
            }
            break;
        default:
            break;
        }
    }
}

void limits_window(void)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    VIEWITEMS_PARSER pre_my_vitems;

    while(1){
        VIEWITEMS my_vitems(pre_my_vitems);
        my_vitems.read(cf_limits); // load file data

        my_dialog.remove_all(); // cleans window
        my_dialog.newf_head("", MSG_U(F_LIMDTIV, "domain\ttype\titem\tvalue"));
        dump_viewitems_to_list(my_dialog, my_vitems, 4);

        /* opens dialog.. */
        my_selection=0;
        my_button=my_dialog.editmenu(MSG_U(T_LIMLIMITS, "Limits (pam_limits.so)"), MSG_U(I_LIMLIMITS, "These are limits' settings for system resources\n(such as CPU usage, memory, etc)"), hf_list_edit, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            my_vitems.add(new VIEWITEM(MSG_U(X_LIM_SAMPLE, "some_domain some_type some_item 0")));
            line_properties_limits(my_vitems.getnb()-1, my_vitems);
            break;
        default:
            line_properties_limits(my_selection, my_vitems);
            break;
        }
    }
}


