//
// This module has been built by Gustavo Niemeyer <niemeyer@conectiva.com>
//
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "opensshd.h"
#include "opensshd.m"

MODULE_DEFINE_VERSION(opensshd);

PUBLIC MODULE_opensshd::MODULE_opensshd()
	: LINUXCONF_MODULE("opensshd")
{
	linuxconf_loadmsg ("opensshd",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_opensshd::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_opensshd,"Secure Shell Daemon (openssh)");
		dia.new_menuitem ("opensshd","",keymenu);
	}
}

PUBLIC int MODULE_opensshd::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
			opensshd_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_opensshd::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"opensshd")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module opensshd\n"
		 "linuxconf --modulemain opensshd [ specific options ]\n"
		 "\n")
		);
}

PUBLIC void MODULE_opensshd::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_opensshd::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"opensshd")==0){
		ret = -1;
		if (argc == 1){
			opensshd_edit();
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_opensshd opensshd;

