#include <stdio.h>
#include <unistd.h>
#include <limits.h>
#include <sstream.h>
#include "netadm.h"
#include "netadm.m"
#include "internal.h"
#include <context.h>
#include <netconf.h>
#include "../paths.h"
#include <string.h>

static NETADM_HELP_FILE help_group("group");

static const char K_CLUSTER[]="cluster";
static const char K_INDEX[]="index";
static const char K_DESC[]="desc";
static const char K_COMMAND[]="command";
static const char K_SUBSYS[]="subsys";
static const char K_MEMBER[]="member";
static const char K_TREE[]="tree";

PUBLIC CLUSTER::CLUSTER()
{
	command.setfrom ("ssh");
}
PUBLIC CLUSTER::CLUSTER(const char *_id)
{
	id.setfrom (_id);
	char key[100];
	sprintf (key,"%s-%s",K_CLUSTER,_id);
	comment.setfrom (linuxconf_getval(key,K_DESC));
	command.setfrom (linuxconf_getval(key,K_COMMAND,"ssh"));
	tree.setfrom (linuxconf_getval(key,K_TREE));
	linuxconf_getall (key,K_MEMBER,members,1);
	linuxconf_getall (key,K_SUBSYS,subsyss,1);
}

PUBLIC int CLUSTER::publish()
{
	net_introlog (NETINTRO_PUBLISH);
	net_prtlog (NETLOG_SECTION,MSG_U(I_PUBLISHING
		,"Publishing admin tree %s to group %s\n")
		,tree.get(),id.get());
	char treepath[PATH_MAX];
	if (tree.cmp("/")==0){
		strcpy (treepath,"/");
	}else{
		sprintf (treepath,"%s/%s",ETC_LINUXCONF_ADMTREES,tree.get());
	}
	LINUXCONF_CONTEXT tmp (ui_context);
	LINUXCONF_CONTEXT ctx(treepath);
	ui_context.set (ctx);
	char indexsum[PATH_MAX];
	sprintf (indexsum,"%s/%s/index.sum",ETC_LINUXCONF_GROUPS,id.get());
	unlink (indexsum);
	SSTREAM_NUL ssnull;
	int ret = configf_archive (subsyss,"netadmpublish.sh",id.get(),ssnull,false);
	ui_context.set(tmp);
	char indexsys[PATH_MAX];
	sprintf (indexsys,"%s/%s/index.subsys",ETC_LINUXCONF_GROUPS,id.get());
	if (ret != -1){
		FILE *fout = fopen (indexsys,"w");
		if (fout != NULL){
			for (int i=0; i<subsyss.getnb(); i++){
				fprintf (fout,"%s\n",subsyss.getitem(i)->get());
			}
			fclose (fout);
		}
	}else{
		unlink (indexsys);
	}
	return ret;
}

PRIVATE void CLUSTER::update_subsyss(SSTRINGS &tbsys, char tbsys_sel[])
{
	subsyss.remove_all();
	for (int i=0; i<tbsys.getnb(); i++){
		if (tbsys_sel[i]){
			subsyss.add (new SSTRING(tbsys.getitem(i)->get()));
		}
	}
}


PUBLIC int CLUSTER::edit()
{
	DIALOG dia;
	dia.newf_str (MSG_U(F_ID,"Group ID"),id);
	dia.last_noempty();
	dia.newf_str (MSG_U(F_DESC,"Description"),comment);
	FIELD_COMBO *comb = dia.newf_combo (MSG_U(F_ADMTREE,"Administration tree")
		,tree);
	dia.last_noempty();
	{
		SSTRINGS tb;
		tree_getlist (tb);
		comb->addopt ("/");
		for (int i=0; i<tb.getnb(); i++){
			comb->addopt (tb.getitem(i)->get());
		}
	}
	comb = dia.newf_combo (MSG_R(F_COMMAND),command);
	export_setcommands (comb);
	dia.newf_title ("",MSG_U(T_MEMBERS,"members"));
	int i;
	for (i=0; i<4; i++){
		members.add (new SSTRING);
		subsyss.add (new SSTRING);
	}
	for (i=0; i<members.getnb(); i++){
		SSTRING *s = members.getitem(i);
		dia.newf_str ("",*s);
	}
	dia.newf_title ("",MSG_U(T_SUBSYS,"Sub-systems"));
	SSTRINGS tbsys,titles;	
	subsys_getallsubsys(tbsys,titles);
	int nbsys = tbsys.getnb();
	char tbsys_sel[nbsys];
	for (i=0; i<nbsys; i++){
		tbsys_sel[i] = 0;
		const char *sys = tbsys.getitem(i)->get();
		for (int j=0; j<subsyss.getnb(); j++){
			SSTRING *s = subsyss.getitem(j);
			if (s->cmp(sys)==0){
				tbsys_sel[i] = 1;
				break;
			}
		}
		dia.newf_chk (sys,tbsys_sel[i],titles.getitem(i)->get());
	}
	int nof=0;
	int ret = -1;
	dia.setbutinfo (MENU_USR1,MSG_U(B_PUBLISH,"Publish"),"Publish");
	dia.setbutinfo (MENU_USR2,MSG_U(B_EXPORT,"Export"),"Export");
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_CLUSDEF,"Cluster specifications")
			,MSG_U(I_CLUSDEF
				,"You must specify which machine are member of the cluster\n"
				 "and which sub-systems are managed from this station.\n"
				 "All these sub-systems will be synchronised on the\n"
				 "various members of the administration cluster.")
			,help_group
			,nof,MENUBUT_DEL|MENUBUT_ADD
				|MENUBUT_USR1|MENUBUT_USR2
				|MENUBUT_ACCEPT|MENUBUT_CANCEL);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_DEL){
			if (xconf_delok()){
				delinfo();
				ret = 1;
				break;
			}
		}else if (code == MENU_ADD){
		}else if (code == MENU_USR1){
			dia.save();
			members.remove_empty();
			update_subsyss (tbsys,tbsys_sel);
			publish();
			break;
		}else if (code == MENU_USR2){
			dia.save();
			members.remove_empty();
			update_subsyss (tbsys,tbsys_sel);
			exportall(command.get());
			break;
		}else if (id.strchr(' ')!=NULL){
			xconf_error (MSG_U(E_NOSPACEID,"No space allowed in the ID"));
			nof = 0;
		}else{
			ret = 0;
			members.remove_empty();
			update_subsyss (tbsys,tbsys_sel);
			break;
		}
	}
	members.remove_empty();
	return ret;
}

PUBLIC CLUSTERS::CLUSTERS()
{
	SSTRINGS tb;
	linuxconf_getall (K_CLUSTER,K_INDEX,tb,0);
	for (int i=0; i<tb.getnb(); i++){
		add (new CLUSTER(tb.getitem(i)->get()));
	}
}

PUBLIC CLUSTER* CLUSTERS::getitem (int no) const
{
	return (CLUSTER*)ARRAY::getitem(no);
}

PRIVATE void CLUSTER::delinfo()
{
	char key[100];
	sprintf (key,"%s-%s",K_CLUSTER,id.get());
	linuxconf_removeall (key,K_SUBSYS);
	linuxconf_removeall (key,K_MEMBER);
	linuxconf_removeall (key,K_DESC);
	linuxconf_removeall (key,K_TREE);
}

PUBLIC void CLUSTER::write ()
{
	char key[100];
	sprintf (key,"%s-%s",K_CLUSTER,id.get());
	delinfo();
	int i;
	linuxconf_add (K_CLUSTER,K_INDEX,id);
	linuxconf_add (key,K_DESC,comment);
	linuxconf_add (key,K_COMMAND,command);
	linuxconf_add (key,K_TREE,tree);
	for (i=0; i<members.getnb(); i++){
		linuxconf_add (key,K_MEMBER,members.getitem(i)->get());
	}
	for (i=0; i<subsyss.getnb(); i++){
		linuxconf_add (key,K_SUBSYS,subsyss.getitem(i)->get());
	}
}

PUBLIC int CLUSTERS::write()
{
	linuxconf_setcursys (subsys_netadm);
	linuxconf_removeall (K_CLUSTER,K_INDEX);
	for (int i=0; i<getnb(); i++){
		getitem(i)->write();
	}
	return linuxconf_save();
}

/*
	Publish all admin groups that are related to one admin tree
*/
PUBLIC int CLUSTERS::publish (const char *tree)
{
	int ret = 0;
	SSTRING groups;
	for (int i=0; i<getnb() && ret != -1; i++){
		CLUSTER *c = getitem(i);
		if (c->tree.cmp(tree)==0){
			ret |= c->publish();
			if (ret == 0) groups.appendf ("\t%s\n",c->id.get());
		}
	}
	if (!groups.is_empty()){
		xconf_notice (MSG_U(N_PUBLISHDONE
			,"Admin tree %s published to group(s)\n"
			"%s")
			,tree,groups.get());
	}
	return ret;
}

PUBLIC int CLUSTERS::edit ()
{
	DIALOG_RECORDS dia;
	int nof = 0;
	int ret = -1;
	dia.newf_head ("",MSG_U(H_GROUPES,"Groupe ID\tDescription"));
	while (1){
		for (int i=0; i<getnb(); i++){
			CLUSTER *c = getitem(i);
			dia.set_menuitem (i,c->id.get(),c->comment.get());
		}
		dia.remove_last(getnb()+1);
		MENU_STATUS code = dia.editmenu (
			MSG_U(T_CLUSTERS,"Administration groups")
			,MSG_U(I_CLUSTERS,"Here is the list of administration groups.")
			,help_group
			,nof,MENUBUT_ADD);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			CLUSTER *clu = new CLUSTER;
			if (editone (clu)!=-1) ret = 0;
		}else{
			if (editone (nof) != -1) ret = 0;
		}
	}
	return ret;
}

