
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "mouseconf.h"
#include "mouseconf.m"
#include <dirent.h>
/* oops.. linuxconf doesn't like popen much, should change this later */
#include <popen.h>

#include "fviews.h"

int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number, int to_eol);
int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number);
int ci_strcmp(const char *str1, const char *str2);

/* self explaining */
int execute_proggy_and_get_stdout(const char *given_command_line, char *output_buffer, int output_buffer_size)
{
    char my_command[500];
    char my_args[500];
    char *where_to_cut;

    *output_buffer=0;

    my_command[0]=0;
    my_args[0]=0;
    strcpy(my_command, given_command_line);
    if((where_to_cut=strchr(my_command, ' '))){
        *where_to_cut=0;
        where_to_cut++;
        strcpy(my_args, where_to_cut);
    }

    POPEN my_popen(my_command, my_args);
    while(!my_popen.wait(5000, 0));

    {
        int my_rem_bytes=output_buffer_size;
        int my_step;

        while((my_step=my_popen.readoutraw((output_buffer+strlen(output_buffer)), my_rem_bytes))){
            my_rem_bytes-=my_step;
            my_popen.wait(5000, 0);
        }
    }

    return(my_popen.close());
}

void informational_window(const char *my_title, const char *my_text)
{
    int nothing=0;
    DIALOG uhoh_dialog;

    uhoh_dialog.edit(my_title, my_text, help_nil, nothing, MENUBUT_OK);
}

/* return true if yes, false if no */
int confirm_yesno_window(const char *my_title, const char *my_text)
{
    if(dialog_yesno(my_title, my_text, help_nil)==MENU_YES){
        return(1);
    } else {
        return(0);
    }
}

/* provided string has "something".. leaves just the -something-
   ok, it just cuts the first and last characters */
/* returns pointer to char buffer */
const char *cuts_quotes_off(SSTRING &given_string)
{
    SSTRING temp_str;
    int     original_size;

    original_size=given_string.getlen();
    if(original_size>1){
        temp_str.setfrom(given_string.get()+1);
        temp_str.truncate(original_size-2);
        given_string.setfrom(temp_str.get());
    }
    return(given_string.get());
}

/* compare the first two elements in string if they are the same as the two provided ones */
/* (case insensitive) */
/* return 0 if equal */
int compare_double_str_ci(const char *wholething, const char *givenstr1, const char *givenstr2)
{
    SSTRING    temp_line_1, temp_line_2;

    gimme_word_from_string(wholething, temp_line_1, 0);
    gimme_word_from_string(wholething, temp_line_2, 1);
    if((!ci_strcmp(temp_line_1.get(), givenstr1))&&(!ci_strcmp(temp_line_2.get(), givenstr2)))
        return(0);
    return(1);
}

/* case insensitive strcmp() */
int ci_strcmp(const char *str1, const char *str2)
{
    SSTRING str1b, str2b;

    str1b.setfrom(str1);
    str2b.setfrom(str2);

    str1b.to_lower();
    str2b.to_lower();

    return(strcmp(str1b.get(), str2b.get()));
}

int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number)
{
    return(gimme_word_from_string(given_string, write_here, word_number, 0));
}

/* picks a 'word' (string-particle between spaces) from a string */
/* if to_eol!=0 copy from word beginning to end of line (not only the word itself */
/* returns !=0 if non-empty string returned */
int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number, int to_eol)
{
    const char *read_from,
               *copy_from;
    int  my_counter;

    read_from=given_string;

    /* ignores heading spaces */
    while((*read_from)&&(*read_from<=' '))
        read_from++;

    /* finds the beginning of word */
    my_counter=word_number;
    while(my_counter--){
        while((*read_from)&&(*read_from>' '))
            read_from++;
        while((*read_from)&&(*read_from<=' '))
            read_from++;
    }

    /* finds the length of the word and copies string */
    if((copy_from=read_from)){
        my_counter=0;
        if(!to_eol){
            while((*read_from)&&(*read_from>' ')){
                read_from++;
                my_counter++;
            }
        }else{
            while(*read_from++)
                my_counter++;
        }

        write_here.setfrom(copy_from);
        write_here.truncate(my_counter);
    }else{
        write_here.setfrom("");
    }

    if(!*write_here.get()) /* if empty string returned.. */
        return(0);
    return(1);
}

void adjust_vars(void)
{
    if(!strcmp(mouse_prefs.description.get(), "searching definition...")){
        informational_window("Mouseconf", "This module was created by\nDaniel Mealha Cabrita (dancab@conectiva.com)\n");
    }
}

/* gives the group location (includes the start and end lines)
 returns !=0 if ok, ==0 not found
 starts search from start_from line */
int find_group_limits(VIEWITEMS &given_vitems, const char *given_start, const char *given_end, int &startline, int &endline, int start_from)
{
    int remains, current_pos;
    const char *current_line;
    SSTRING given_start1, given_start2; // beginning is limited to 2 elements
    SSTRING given_end1; // end is limited to 1 element
    SSTRING temp_str;

    /* breaks given start in two */
    gimme_word_from_string(given_start, given_start1, 0);
    gimme_word_from_string(given_start, given_start2, 1);
    /* picks only first part of end */
    gimme_word_from_string(given_end, given_end1, 0);

    remains=given_vitems.getnb() - start_from;
    current_pos=start_from;
    startline=0;
    endline=given_vitems.getnb()-1;

    while(remains--){
        current_line=given_vitems.getitem(current_pos++)->line.get();
        /* find beginning of group */
        if(!compare_double_str_ci(current_line, given_start1.get(), given_start2.get())){
            startline=current_pos-1;
            while(remains--){
                current_line=given_vitems.getitem(current_pos++)->line.get();
                gimme_word_from_string(current_line, temp_str, 0);
                if(!ci_strcmp(temp_str.get(), given_end1.get())){
                    endline=current_pos-1;
                    return(1);
                }
            }
        }
    }

    return(0);
}

int fill_sstrings_with_filenames(const char *given_dirname, SSTRINGS &given_sstrings)
{
    DIR *my_dir;
    struct dirent *ent;
    int my_counter=0;

    if((my_dir=opendir(given_dirname))){
        while((ent=readdir(my_dir))){
            if(strcmp(ent->d_name, ".")&&strcmp(ent->d_name, "..")){
                given_sstrings.add(new SSTRING(ent->d_name));
                my_counter++;
            }
        }
        closedir(my_dir);
    }
    return(my_counter);
}


