#include <string.h>
#include <limits.h>
#include "dnsconf.h"
#include "internal.h"
#include "dnsconf.m"
#include <dialog.h>

extern DNSCONF_HELP_FILE help_dnsedit;

class RECORD_ITEM: public ARRAY_OBJ{
public:
	RECORD *rec;
	char relname[100];	// Relative name of the record
	/*~PROTOBEG~ RECORD_ITEM */
public:
	RECORD_ITEM (RECORD *rec, const char *relname);
	/*~PROTOEND~ RECORD_ITEM */
};
PUBLIC RECORD_ITEM::RECORD_ITEM (RECORD *rec, const char *relname)
{
	this->rec = rec;
	strcpy(this->relname,relname);
}

class RECORD_ITEMS: public ARRAY{
	/*~PROTOBEG~ RECORD_ITEMS */
public:
	RECORD_ITEM *getitem (int no)const;
	/*~PROTOEND~ RECORD_ITEMS */
};

PUBLIC RECORD_ITEM *RECORD_ITEMS::getitem(int no) const
{
	return (RECORD_ITEM*)ARRAY::getitem(no);
}

static int cmp_record_by_name (const ARRAY_OBJ *o1, const ARRAY_OBJ *o2)
{
	RECORD_ITEM *i1 = (RECORD_ITEM *)o1;
	RECORD_ITEM *i2 = (RECORD_ITEM *)o2;
	return strcmp(i1->relname,i2->relname);
}


/*
	Present all record in the primary and let edit one
*/
PUBLIC void ZONE::edithosts(DNS &dns)
{
	int nof = 0;
	DIALOG_LISTE dia;
	dia.newf_head ("",MSG_U(H_HOST,"Name\tValue"));
	dia.addwhat (MSG_U(I_ANEWHOST,"Select [Add] tp add a new host/sub-domain"));
	while (1){
		/* #Specification: Primary / editing by list / strategy
			We extract all the names available in the domaine (be it a CNAME
			or a NS  or A record and then we sort them and eliminate the
			identical one. We do this because linuxconf provide a global
			view of all the characteristic of a name.
		*/
		RECORD_ITEMS tb;
		int i;
		for (i=0; i<origins.getnb(); i++){
			ORIGIN *ori = origins.getitem(i);
			RECORDS *tbrec = &ori->tbrec;
			int nrec = tbrec->getnb();
			for (int r=0; r<nrec; r++){
				RECORD *rec = tbrec->getitem(r);
				RECORD_TYPE id = rec->id;
				SSTRING *s = NULL;
				if (id == RTYPE_A){
					RECORD_IN_A *reca = (RECORD_IN_A*)rec;
					s = &reca->name;
				}else if (id == RTYPE_CNAME){
					RECORD_IN_CNAME *reca = (RECORD_IN_CNAME*)rec;
					s = &reca->nickname;
				}else if (id == RTYPE_NS){
					RECORD_IN_NS *reca = (RECORD_IN_NS*)rec;
					s = &reca->name;
				}else if (id == RTYPE_MX){
					RECORD_IN_MX *reca = (RECORD_IN_MX*)rec;
					s = &reca->mailname;
				}
				if (s != NULL && !s->is_empty() && s->cmp("@")!=0){
					tb.add(new RECORD_ITEM(rec,s->get()));
				}
			}
		}
		tb.sort (cmp_record_by_name);
		int n = tb.getnb();
		const char *lastname = "";
		char data[200];
		data[0] = '\0';
		SSTRINGS tbs;
		for (i=0; i<n; i++){
			RECORD_ITEM *rec = tb.getitem(i);
			if (strcmp(lastname,rec->relname)!=0){
				if (lastname[0] != '\0'){
					dia.set_menuitem (tbs.getnb(),lastname,data);
					tbs.add (new SSTRING(lastname));
				}
				lastname = rec->relname;
				data[0] = '\0';
			}
			RECORD *r = rec->rec;	
			RECORD_TYPE id = r->id;
			if (data[0] != '\0') strcat (data," ");
			if (id == RTYPE_A){
				RECORD_IN_A *reca = (RECORD_IN_A*)r;
				strcat (data,reca->addr.get());
			}else if (id == RTYPE_CNAME){
				RECORD_IN_CNAME *reca = (RECORD_IN_CNAME*)r;
				sprintf (data,"-> %s",reca->name.get());
			}else if (id == RTYPE_NS){
				strcat (data,"[NS]");
			}else if (id == RTYPE_MX){
				strcat (data,"[MX]");
			}
		}
		if (lastname[0] != '\0'){
			dia.set_menuitem (tbs.getnb(),lastname,data);
			tbs.add (new SSTRING(lastname));
		}
		dia.remove_last (tbs.getnb()+1);
		MENU_STATUS code = dia.editmenu (
			MSG_U(T_SELHOST,"Hosts to edit")
			,""
			,help_dnsedit
			,nof,MENUBUT_ADD);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			char buf[PATH_MAX];
			sprintf (buf,".%s",domain.get());
			dns.editrecs (buf);
		}else if (nof >= 0 && nof < n){
			const char *name = tbs.getitem(nof)->get();
			char fullname[PATH_MAX];
			sprintf (fullname,"%s.%s",name,domain.get());
			dns.editone(fullname);
		}
	}
}

static int cmp_primary_by_name (const ARRAY_OBJ *o1, const ARRAY_OBJ *o2)
{
	PRIMARY *s1 = (PRIMARY*)o1;
	PRIMARY *s2 = (PRIMARY*)o2;
	return s1->domainv.cmp(s2->domainv);
}



/*
	Format the menu to select one domain
*/
PRIVATE void PRIMARYS::setselect (DIALOG &dia, PRIMARYS &sorted)
{
	int nb = getnb();
	sorted.neverdelete();
	for (int i=0; i<nb; i++) sorted.add (getitem(i));
	/* #Specification: domains / edition / sorting
		Domain are always sorted before being presented. But the
		sorting is done in a temporary object, so this does not change
		the ordering in /etc/named.conf
	*/
	sorted.sort(cmp_primary_by_name);
	if (dia.getnb()==0){
		dia.newf_head (""
			,is_reverse()
				? MSG_U(H_DOMAINREV,"Domain\tRange\tRevision date\tRevision count")
				: MSG_U(H_DOMAIN,"Domain\tRevision date\tRevision count"));
	}
	for (int i=0; i<nb; i++){
		PRIMARY *pri = sorted.getitem(i);
		char buf[100];
		pri->format_revision (buf);
		if (is_reverse()){
			SSTRING tmp;
			tmp.setfromf ("%s\t%s",pri->getrange(),buf);
			dia.set_menuitem (i,pri->domainv.get(),tmp.get());
		}else{
			dia.set_menuitem (i,pri->domainv.get(),buf);
		}
	}
	dia.remove_last (nb+1);
}
/*
	Present the list of primarys. Show selectivly the
	standard domain primaris or the reverse mapping primarys.
*/
PUBLIC void PRIMARYS::editbydom(DNS &dns)
{
	if (getnb()==0){
		xconf_error (MSG_U(E_NODOMAINDEF,"No domain defined yet"));
	}else{
		int choice=0;
		DIALOG_LISTE dia;
		PRIMARYS sorted;
		setselect (dia,sorted);
		while (1){
			MENU_STATUS code = dia.editmenu(
				MSG_U(T_EDITBYDOM,"Edit hosts by domain")
				,""
				,help_dnsedit
				,choice,0);
			if (code == MENU_QUIT || code == MENU_ESCAPE){
				break;
			}else if (choice >= 0 && choice < getnb()){
				PRIMARY *p = sorted.getitem(choice);
				p->edithosts(dns);
			}
		}
	}
}

