
/* dump types */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "amandaconf.h"
#include "amandaconf.m"

#include "am_tools.h"
#include "lame_parser.h"

void edit_specified_dumptype(t_parser_control *parser_control, const char *dumptype_name)
{
    struct {
        SSTRING auth,
            comment,
            compress,
            exclude,
            priority,
            program,
            strategy;
        complexfloat comprate;
        complexbool holdingdisk,
            ignore,
            index,
            kencrypt,
            record,
            skip_full,
            skip_incr;
        complexint dumpcycle;
        complexintquoted maxdumps,
            starttime;
    } my_intvars;

    const char *groupname;
    SSTRING sgroupname;
    SSTRING dialog_title;
    DIALOG my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    sgroupname.setfromf("define dumptype %s {", dumptype_name);
    groupname=sgroupname.get();

    /* loads vars.. */
    bload_str(auth,"auth");
    bload_str(comment,"comment");
    bload_str(compress,"compress");
    bload_str(exclude,"exclude");
    bload_str(priority,"priority");
    bload_str(program,"program");
    bload_str(strategy,"strategy");
    bload_float(comprate,"comprate");
    bload_bool(holdingdisk,"holdingdisk");
    bload_bool(ignore,"ignore");
    bload_bool(index,"index");
    bload_bool(kencrypt,"kencrypt");
    bload_bool(record,"record");
    bload_bool(skip_full,"skip-full");
    bload_bool(skip_incr,"skip-incr");
    bload_cint(dumpcycle,"dumpcycle");
    bload_cintq(maxdumps,"maxdumps");
    bload_cintq(starttime,"starttime");

    /* builds gui.. */
    bgui_strcombo(auth,MSG_U(F_AUTHTYPE,"Auth. type:"));
        bgui_comboitem(auth,"bsd");
        bgui_comboitem(auth,"krb4");
    bgui_str(comment,MSG_U(F_COMMENT,"Comment:"));
    bgui_float(comprate,MSG_U(F_EXPCOMPRESSION,"Exp. compression:"));
    bgui_strcombo(compress,MSG_U(F_COMPRESSIONTYPE,"Compression type:"));
        bgui_comboitem(compress,"compress none");
        bgui_comboitem(compress,"compress client fast");
        bgui_comboitem(compress,"compress client best");
        bgui_comboitem(compress,"compress server fast");
        bgui_comboitem(compress,"compress server best");
    bgui_cint(dumpcycle,MSG_U(F_DUMPCYCLE,"Dump cycle:"));
    bgui_str(exclude,MSG_U(F_TAREXCLUDE,"TAR \"exclude\" opt.:"));
    bgui_bool(holdingdisk,MSG_U(F_USEHOLDINGDISK,"Use holding disk:"));
    bgui_bool(ignore,MSG_U(F_IGNORE,"Ignore this one:"));
    bgui_bool(index,MSG_U(F_GENERATEINDEX,"Generate index:"));
    bgui_bool(kencrypt,MSG_U(F_ENCRYPTWKERBEROS,"Encrypt w/ Kerberos:"));
    bgui_cintq(maxdumps,MSG_U(F_MAXDUMPS,"Max. dumps:"));
    bgui_strcombo(priority,MSG_U(F_PRIORITY,"Priority:"));
        bgui_comboitem(priority,"high");
        bgui_comboitem(priority,"medium");
        bgui_comboitem(priority,"low");
    bgui_strcombo(program,MSG_U(F_BACKUPPROGRAM,"Backup program:"));
        bgui_comboitem(program,"DUMP");
        bgui_comboitem(program,"GNUTAR");
    bgui_bool(record,MSG_U(F_UPDATEDBTIMESTAMPS,"Update db time stamps:"));
    bgui_bool(skip_full,MSG_U(F_SKIPFULL,"Skip full:"));
    bgui_bool(skip_incr,MSG_U(F_SKIPINCREMENTAL,"Skip incremental:"));
    bgui_cintq(starttime,MSG_U(F_STARTAT,"Start at:"));
    bgui_strcombo(strategy,MSG_U(F_STRATEGY,"Strategy:"));
        bgui_comboitem(strategy,"standard");
        bgui_comboitem(strategy,"nofull");
        bgui_comboitem(strategy,"noinc");
        bgui_comboitem(strategy,"skip");

    /* opens dialog.. */
    dialog_title.setfromf(MSG_U(T_DUMPTYPESETTINGS,"Settings for dump type %s"), dumptype_name);
    my_selection=0;
    my_button=my_dialog.editmenu(dialog_title.get(), "", dumptypes_prop_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);
    adjust_str(my_intvars.comment);

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_ACCEPT:
        /* save vars if requested so.. */
        bsave_str(auth,"auth");
        bsave_str(comment,"comment");
        bsave_str(compress,"compress");
        bsave_str(exclude,"exclude");
        bsave_str(priority,"priority");
        bsave_str(program,"program");
        bsave_str(strategy,"strategy");
        bsave_float(comprate,"comprate");
        bsave_bool(holdingdisk,"holdingdisk");
        bsave_bool(ignore,"ignore");
        bsave_bool(index,"index");
        bsave_bool(kencrypt,"kencrypt");
        bsave_bool(record,"record");
        bsave_bool(skip_full,"skip-full");
        bsave_bool(skip_incr,"skip-incr");
        bsave_cint(dumpcycle,"dumpcycle");
        bsave_cintq(maxdumps,"maxdumps");
        bsave_cintq(starttime,"starttime");

        update_file(parser_control);
        break;
    case MENU_DEL:
        remove_group(parser_control, groupname);
        update_file(parser_control);
        break;
    default:
        break;
    }
}

void select_dumptypes_window(const char *given_groupname, CONFIG_FILE &cf_amandaconf, t_parser_control *parser_control)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    my_dialog.newf_head("", MSG_U(X_DUMPTYPELISTHEAD,"dump types"));

    while(1){
        SSTRINGS list_of_groups;
//        MENU_STATUS my_button=(MENU_STATUS)0;
//        int         my_selection=0;
        int linecounter=0;

//        my_dialog.remove_all(); // cleans window
//        my_dialog.newf_head("", MSG_U(X_DUMPTYPELISTHEAD,"dump types"));

        fills_sstrings_with_selected_groups(parser_control, list_of_groups, "define dumptype ");
        dump_sstrings_to_list(my_dialog, list_of_groups, linecounter);

        // remove entries below (they're the previous ones and useless now)
        my_dialog.remove_last(linecounter+1);

        my_button=my_dialog.editmenu(MSG_U(T_DUMPTYPELIST,"Dump types"), MSG_U(I_DUMPTYPELIST,"Here are defined multiple sets\nof backup options."), dumptypes_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            ask_name_add_group_entry(parser_control, list_of_groups,
                                     "define dumptype %s {",
                                     MSG_U(T_ADDINGNEWDUMPTYPE,"Adding a new dump type..."),
                                     "", MSG_U(F_NAMEFORNEWDUMPTYPE,"Name for the new dump type:"));
            break;
        default:
            {
                SSTRING  whole_groupname;
                SSTRINGS extra_possible_heritages;

                extra_possible_heritages.neverdelete();
                /* these are defined internally in Amanda */
                addthis("no-compress");
                addthis("compress-fast");
                addthis("compress-best");
                addthis("srvcompress");
                addthis("bsd-auth");
                addthis("krb4-auth");
                addthis("no-record");
                addthis("no-hold");
                addthis("no-full");

                whole_groupname.setfromf("define dumptype %s {", list_of_groups.getitem(my_selection)->get());

                if(!group_heritages_are_a_problem(parser_control, "define dumptype ", whole_groupname.get(), &extra_possible_heritages))
                    edit_specified_dumptype(parser_control, list_of_groups.getitem(my_selection)->get());
                break;
            }
        }
    }
}


