#include <ctype.h>
#include <string.h>
#include "misc.h"

void str3_required(){}

/*
	Copy a character sequence delimited by a quote charater.
	The first character of str is taken as the quote character.

	Two consecutive quote character are taken as an escape mecanism
	to incorporate a single quote in the string.

	The escape character is normally '\\'.

	Return the address right after the closing quote.
	May optionnaly "compile" some C escape sequence

	The quote character are omitted.
*/

char *str_copyquotec (
	char *dest,		// Will contain the string inside the two delimiting
					// quote character.
					// May be NULL. Used to skip pass a sequence.
	const char *str,// String beginning with a quote character (any).
	char escape,	// Generally '\\' or '\0' if no escape defined.
	bool compile)	// Should we translate C language special escape (such
					// as '\n'.
{
	char quote = *str++;
	char dummy[10];
	int copie = 1;
	if (dest == NULL){
		dest = dummy;
		copie = 0;
	}
	while (*str != '\0'){
		if (!copie) dest = dummy;
		if (*str == quote){
			str++;
			if (*str == quote){
				if (!compile) *dest++ = quote;
				*dest++ = *str++;
			}else{
				break;
			}
		}else if (*str == escape){
			str++;
			if (compile){
				char res = *str;
				switch (res){
				case 'b':
					res = '\b';
					break;
				case 'f':
					res = '\f';
					break;
				case 'n':
					res = '\n';
					break;
				case 'r':
					res = '\r';
					break;
				case 'a':
					res = '\a';
					break;
				default:
					if (isdigit(res)){
						int base = 8;
						while (1){
							char carac = *str;
							if (isdigit(carac)){
								res = (char)(res * base + carac - '0');
							}else if (carac == 'x' || carac == 'X'){
								base = 16;
							}else if (isxdigit(carac) || base == 16){
								res = (char)(res * base + (carac & 0xf) + 9);
							}else{
								break;
							}
						}
					}else{
						res = *str;
					}
				}
				str++;
				*dest++ = res;
			}else{
				*dest++ = escape;
				if (*str != '\0') *dest++ = *str++;
			}
		}else{
			*dest++ = *str++;
		}
	}
	*dest = '\0';
	return (char*)str;
}

/*
	Copy a character sequence delimited by a quote charater.
	The first character of str is taken as the quote character.

	Two consecutive quote character are taken as an escape mecanism
	to incorporate a single quote in the string.

	The escape is '\\'.

	Return the address right after the closing quote.
	May optionnaly "compile" some C escape sequence

	The quote character are omitted.
*/

char *str_copyquote (
	char *dest,		// Will contain the string inside the quote.
					// May be NULL to skip a quote sequence.
	const char *str)// String starting with a quote character
{
	return str_copyquotec(dest,str,'\0',false);
}

