#pragma interface
#ifndef SSTREAM_H
#define SSTREAM_H

class SSTREAM{
public:
	virtual void puts(const char*)=0;
	virtual char *gets(char *, int)=0;
	virtual long getoffset()=0;
	/*~PROTOBEG~ SSTREAM */
public:
	int printf (const char *ctl, ...);
	void putch (char c);
	virtual ~SSTREAM (void);
	/*~PROTOEND~ SSTREAM */
};


class SSTREAM_BUF: public SSTREAM {
	char *buf;
	int cursize;
	int maxsize;
	/*~PROTOBEG~ SSTREAM_BUF */
public:
	SSTREAM_BUF (const char *_buf);
	SSTREAM_BUF (void);
	const char *getbuf (void)const;
	long getoffset (void);
	char *gets (char *s, int maxs);
	void puts (const char *s);
	~SSTREAM_BUF (void);
	/*~PROTOEND~ SSTREAM_BUF */
};

class SSTREAM_FILE: public SSTREAM {
	FILE *f;
	/*~PROTOBEG~ SSTREAM_FILE */
public:
	SSTREAM_FILE (FILE *_f);
	long getoffset (void);
	char *gets (char *s, int maxs);
	void puts (const char *s);
	/*~PROTOEND~ SSTREAM_FILE */
};

class FILE_CFG;

class SSTREAM_FILE_CFG: public SSTREAM {
	FILE_CFG *f;
	/*~PROTOBEG~ SSTREAM_FILE_CFG */
public:
	SSTREAM_FILE_CFG (FILE_CFG *_f);
	long getoffset (void);
	char *gets (char *s, int maxs);
	void puts (const char *s);
	/*~PROTOEND~ SSTREAM_FILE_CFG */
};

class SSTREAM_NUL: public SSTREAM {
	/*~PROTOBEG~ SSTREAM_NUL */
public:
	long getoffset (void);
	char *gets (char *, int);
	void puts (const char *);
	/*~PROTOEND~ SSTREAM_NUL */
};

#endif

