#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <misc.h>
#include <dialog.h>
#include <translat.h>
#include "main.m"
#include <userconf.h>

#if 0
bool simul_ison()
{
	return false;
}
#endif

void linuxconf_main(bool)
{
}

bool ipnum_validnet (const char *, const char *)
{
	return false;
}
static int wrapper_exec (int argc, char *argv[])
{
	int ret = -1;
	const char *home = getenv ("HOME");
	if (home != NULL){
		/* #Specification: linuxconf_wrapper / main config file
			Modules running in standalone mode (using linuxconf-wrapper)
			can use linuxconf_get/set/replace and so on. But it is
			stored in $HOME/.linuxconf/module-name.conf
		*/
		char dbpath[PATH_MAX];
		snprintf (dbpath,sizeof(dbpath)-1,"%s/.linuxconf",home);
		mkdir (dbpath,0700);
		snprintf (dbpath,sizeof(dbpath)-1,"%s/.linuxconf/%s.conf"
			,home,argv[0]);
		linuxconf_setdbpath (dbpath);
	}
	char path[PATH_MAX];
	if (module_locate(argv[0],path)!=-1){
		module_loadcheck (path);
		ret = module_execmain (argc,argv,true);
	}
	return ret;
}


int main (int argc, char *argv[])
{
	int ret = -1;
	perm_setbypass(true);
	argc = dialog_parseuioptions (argc, argv);
	linuxconf_loadmsg ("linuxconf",PACKAGE_REV);
	translat_checkmissing();
	dialog_clear();
	char *argv0 = argv[0];
	char *pt = strrchr(argv0,'/');
	if (pt != NULL) argv0 = pt+1;
	if (strcmp(argv0,"linuxconf-wrapper")==0){
		if (argc < 2){
			fprintf (stderr,MSG_U(I_WRAPPER,"linuxconf-wrapper module-name\n"));
		}else{
			ret = wrapper_exec (argc-1,argv+1);
		}
	}else{
		argv[0] = argv0;
		ret = wrapper_exec (argc,argv);
	}
	return ret;
}

