#pragma interface
#ifndef FIXPERM_H
#define FIXPERM_H

#include <sys/param.h>

#ifndef MISC_H
	#include <misc.h>
#endif

struct SPEC_ONE;
class FIXPERM_SPECS;

class FIXPERM_TASK{
public:
	FIXPERM_TASK *next;
	virtual int check(bool boottime, bool silentflag)=0;
	virtual void list(FIXPERM_SPECS &specs)=0;
	/*~PROTOBEG~ FIXPERM_TASK */
public:
	FIXPERM_TASK (void);
	/*~PROTOEND~ FIXPERM_TASK */
};

struct FIXPERM_OPTIONS{
	bool boot;
	bool recurse;
	bool required;
	bool silent;
};


class FIXPERM_SPEC: public ARRAY_OBJ{
public:
	SSTRING path;
	SSTRING owner;
	SSTRING group;
	mode_t perm;
	dev_t dev;
	FIXPERM_OPTIONS opts;
	//uid_t uid;
	//gid_t gid;
	bool valid;		// Is this record valid
	/*~PROTOBEG~ FIXPERM_SPEC */
public:
	FIXPERM_SPEC (SPEC_ONE&sp);
	int check (void);
	int create (PERMINFO&p);
	int edit (void);
private:
	void parsedev (SPEC_ONE&sp);
public:
	/*~PROTOEND~ FIXPERM_SPEC */
};

class FIXPERM_SPECS: public ARRAY{
	/*~PROTOBEG~ FIXPERM_SPECS */
public:
	FIXPERM_SPECS (const char *fname);
	FIXPERM_SPECS (void);
	void addline (const char *buf);
private:
	void addline (const char *buf, SPEC_ONE&sp);
public:
	int check (bool boottime, bool silentflag);
	int check (void);
	FIXPERM_SPEC *getitem (int no);
	int readspecf (const char *fname);
	/*~PROTOEND~ FIXPERM_SPECS */
};

struct PERMINFO{
	SSTRING owner;
	SSTRING group;
	mode_t perm;
	uid_t uid;
	gid_t gid;
};

#endif

