/*
 * $Id: bootsect.h,v 1.7 2001/06/01 02:07:24 antona Exp $
 *
 * bootsect.h - Exports for bootsector record handling. Part of the Linux-NTFS
 *		project.
 *
 * Copyright (c) 2000,2001 Anton Altaparmakov.
 *
 * This program/include file is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program/include file is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (in the main directory of the Linux-NTFS 
 * distribution in the file COPYING); if not, write to the Free Software
 * Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef BOOTSECT_H
#define BOOTSECT_H

#include "types.h"

/* The NTFS oem_id */
#define magicNTFS	cpu_to_le64(0x202020205346544e) /* "NTFS    " */

/*
 * Location of bootsector on partition:
 * 	The standard NTFS_BOOT_SECTOR is on sector 0 of the partition.
 * 	On NT4 and above there is one backup copy of the boot sector to
 * 	be found on the last sector of the partition (not normally accessible
 * 	from within Windows as the bootsector contained number of sectors
 *	value is one less than the actual value!).
 * 	On versions of NT 3.51 and earlier, the backup copy was located at 
 * 	number of sectors/2 (integer divide), i.e. in the middle of the volume.
 */

/*
 * BIOS parameter block (bpb) structure.
 */
typedef struct {
	__u16 bytes_per_sector;		/* Size of a sector in bytes. */
	__u8  sectors_per_cluster;	/* Size of a cluster in sectors. */
	__u16 reserved_sectors;		/* zero */
	__u8  fats;			/* zero */
	__u16 root_entries;		/* zero */
	__u16 sectors;			/* zero */
	__u8  media_type;		/* 0xf8 = hard disk */
	__u16 sectors_per_fat;		/* zero */
	__u16 sectors_per_track;	/* irrelevant, we set to zero */
	__u16 heads;			/* irrelevant, we set to zero */
	__u32 hidden_sectors;		/* zero */
	__u32 large_sectors;		/* zero */
/* sizeof() = 25 (0x19) bytes */
} __attribute__ ((__packed__)) BIOS_PARAMETER_BLOCK;

/*
 * Boot sector structure.
 */
typedef struct {
	__u8  jump[3];			/* Irrelevant (jump to boot up code).*/
	__u64 oem_id;			/* Magic "NTFS    ". */
	BIOS_PARAMETER_BLOCK bpb;	/* See BIOS_PARAMETER_BLOCK. */
	__u8  unused[4];		/* zero, NTFS diskedit.exe states that
					   this is actually:
					   	__u8 physical_drive;	// 0x80
					 	__u8 current_head;	// zero
						__u8 extended_boot_signature;
									// 0x80
						__u8 unused;		// zero
					 */
/*0x28*/__s64 number_of_sectors;	/* Number of sectors in volume. Gives
					   maximum volume size of 2^63 sectors.
					   Assuming standard sector size of 512
					   bytes, the maximum byte size is
					   approx. 4.7x10^21 bytes. (-; */
	__s64 mft_lcn;			/* Cluster location of mft data. */
	__s64 mftmirr_lcn;		/* Cluster location of copy of mft. */
	__s8  clusters_per_mft_record;	/* Mft record size in clusters. */
	__u8  reserved0[3];		/* zero */
	__s8  clusters_per_index_block;	/* Index block size in clusters. */
	__u8  reserved1[3];		/* zero */
	__s64 volume_serial_number;	/* Irrelevant (serial number). */
	__u32 checksum;			/* Boot sector checksum. */
/*0x54*/__u8  bootstrap[426];		/* Irrelevant (boot up code). */
	__u16 end_of_sector_marker;	/* End of bootsector magic. Always is
					   0xaa55 in little endian. */
/* sizeof() = 512 (0x200) bytes */
} __attribute__ ((__packed__)) NTFS_BOOT_SECTOR;

/**
 * is_boot_sector_ntfs - check a boot sector for describing an ntfs volume
 * @b:		buffer containing the boot sector
 * @silent:	if 1 don't display progress information
 * 
 * This function checks the boot sector in @b for describing a valid ntfs
 * volume. Return 1 if @b is a valid NTFS boot sector or 0 otherwise. If
 * silent is 0, progress output will be output to stdout. If silent is 1 no
 * output to stdout will occur. Errors/warnings to stderr will occur
 * disregarding the value of silent.
 */
int is_boot_sector_ntfs(const NTFS_BOOT_SECTOR *b, const int silent);

#endif /* defined BOOTSECT_H */

