//LabPlot: Legend.h

#ifndef LEGEND_H
#define LEGEND_H

class QFont;
class QPainter;
class Symbol;
#include "GraphList.h"

class Legend {
public:
	Legend();
	void save(QTextStream *t);
	void open(QTextStream *t, int version);
	QDomElement saveXML(QDomDocument doc);
	void openXML(QDomNode node);
	void setFont(QFont f) { font = f; }
	QFont Font() { return font; }
	void enable(bool b=true) { enabled = b; }
	bool Enabled() { return enabled; }
	void setPosition(double X, double Y) { x = X; y = Y; }
	double X() { return x; }
	double Y() { return y; }
	void enableBorder(bool b=true) { border = b; }
	bool BorderEnabled() { return border; }
	void setColor(QColor c) { color = c; }
	void setColor(QString c) { color = QColor(c); }
	QColor Color() { return color; }
	void setTransparent(bool t=true) { transparent=t; }
	bool Transparent() { return transparent; }
	bool getOrientation() { return orientation; }
	void setOrientation(bool o) { orientation=o; }
	int drawGraphs(QPainter *p, GraphList *gl, PType type, Point size, QFont tmpfont);
	void draw(QPainter *p, PType type, GraphList *graphlist, Point pos, Point size,int w, int h);
	bool inside(int X, int Y);
	int TicLabelLength() { return ticlabellength; }
	void setTicLabelLength(int l) { ticlabellength = l; }
private:
	double x,y;			// position 0..1
	int x1, y1, x2, y2;		// legend box
	QFont font;				// legend font
	bool border;			// border enabled
	bool enabled;				// legend enabled
	QColor color;			// legend background color
	bool transparent;		// transparent ?
	int namelength;		// legend width
	bool orientation;		// 0: BottomTop, 1:LeftRight
	int ticlabellength;		// max length of tic label. used for border 
};

#endif //LEGEND_H
