//LabPlot : LaplaceTransformListDialog.cc

#include "LaplaceTransformListDialog.h"

using namespace std;

LaplaceTransformListDialog::LaplaceTransformListDialog(MainWin *mw, const char *name)
	: ListDialog(mw, name)
{
	setCaption(i18n("LaplaceTransform Dialog"));
	KConfig *config = mw->Config();
	config->setGroup( "LaplaceTransform" );

	Plot *plot=0;
	if(p)
		plot = p->getPlot(p->API());

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	baselinecb = new QCheckBox(i18n("Use Baseline @ y = "),hb);
	baselinecb->setChecked(config->readBoolEntry("Baseline",false));
	double baseline=0;
	if(p)
		baseline = plot->Baseline();
	hb = new QHBox(tab1);
	baselinele = new KLineEdit(QString::number(baseline),hb);
	baselinele->setValidator(new QDoubleValidator(baselinele));

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw,true);
	else
		styletab = simpleStyle(tw, style, symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	save->setEnabled(false);

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

int LaplaceTransformListDialog::apply_clicked() {
	kdDebug()<<" LaplaceTransformListDialog::apply_clicked()"<<endl;
	double baseline = baselinele->text().toDouble();

	// F(s) = \int_0^{\inf} f(t)*exp(-s*t) dt

	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();

		// add two column if needed
		s->addColumn();
		s->addColumn();
		int newxcol = table->numCols()-2;
		int newycol = table->numCols()-1;

		// TODO : integrate

		// insert into last column
		// table->setText(i,newxcol,QString::number(sx));
		// table->setText(i,newycol,QString::number(sy));
		return 0;
	}

	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0) {
		KMessageBox::error(this,i18n("No graph found!"));
		return -2;
	}
	if (baselinecb->isChecked())
		p->getPlot(p->API())->setBaseline(baseline);

	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GRAPHType st = gl->getType(item);
	Style *style=0;
	Symbol *symbol=0;
	if(st != GRAPHM) {
		style = new Style((StylesType)cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			width->value(),pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}

	double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1, tmin=0, tmax=1;
	if (st == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->Data();
		int n=0;

		// F(s) = \int_0^{\inf} f(t)*exp(-s*t) dt
		for (int i=0;i<nx;i++) {
			double x = a[i].X();
			double y=0;
			for(int j=0;j<nx-1;j++) {
				double y1 = a[j].Y(), y2 = a[j+1].Y();
				if (baselinecb->isChecked()) {
					y1 -= baseline;
					y2 -= baseline;
				}
				double dx=a[j+1].X()-a[j].X();
				y += (y1+y2)/2.0*exp(-x*a[j].X())*dx;
			}

			ptr[n++].setPoint(x,y);
		}

		mw->calculateRanges2D(ptr,n,&xmin,&xmax,&ymin,&ymax);

		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString(i18n("LaplaceTransform of")+QString(" ")+g->getLabel()->simpleTitle());

		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,n);
		mw->addGraph2D(ng,sheetcb->currentItem());
	}
	//TODO : other graph types

	updateList();

	return 0;
}
