//LabPlot : LabPlotDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include "LabPlotDialog.h"

#ifdef HAVE_JASPER
#include <jasper/jas_config.h>
#endif

#include <audiofile.h>

#ifdef HAVE_GSL
#include <gsl/gsl_version.h>
#endif

#ifdef HAVE_FFTW_CONFIG
#include <fftw-config.h>
#endif

#ifdef HAVE_MAGICK
#include <magick/api.h>
#include <magick/version.h>
#endif

#ifdef HAVE_QSA
#include <qsaglobal.h>
#endif

#include <liborigin/OPJFile.h>

#ifdef HAVE_CDF_CONFIG
#include <cdfrev.h>
#endif

#ifdef HAVE_HDF5
#include <hdf5.h>
#endif

#ifdef HAVE_R
#include <Rversion.h>
#endif

LabPlotDialog::LabPlotDialog(MainWin *mw,const char *name)
	: Dialog(mw, name)
{
	setCaption(i18n("LabPlot")+i18n(" : ")+QString(name));

	QLabel *tmp;
	QString st("no");

	// TODO : get more versions of libraries
	// TODO : COPYRIGHT infos

	// LabPlot
	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("Version : "),hb);
	tmp = new QLabel(QString(LVERSION),hb);
	tmp->setAlignment(Qt::AlignRight);
	hb = new QHBox(vbox);
	new QLabel(i18n("Project Version : "),hb);
	tmp = new QLabel(QString::number(PROJECT_VERSION),hb);
	tmp->setAlignment(Qt::AlignRight);

	// gsl
	hb = new QHBox(vbox);
	new QLabel(i18n("GNU Scientific Library (GSL) : "),hb);
#ifdef HAVE_GSL
	st = GSL_VERSION;
#endif
	tmp = new QLabel(st,hb);
	tmp->setAlignment(Qt::AlignRight);

	// fftw
	hb = new QHBox(vbox);
	new QLabel(i18n("FFTW 3 : "),hb);
	st = "no";
#ifdef HAVE_FFTW3
	st = "yes";
#endif
	tmp = new QLabel(st,hb);
	tmp->setAlignment(Qt::AlignRight);
	hb = new QHBox(vbox);
	new QLabel(i18n("FFTW : "),hb);
#ifdef HAVE_FFTW_CONFIG
	st = FFTW_VERSION;
#elif defined(HAVE_FFTW3)
	st = "unused";
#elif defined(HAVE_FFTW)
	st = "unknown";
#else
	st = "no";
#endif
	tmp = new QLabel(st,hb);
	tmp->setAlignment(Qt::AlignRight);

	// pstoedit
	hb = new QHBox(vbox);
	new QLabel(i18n("pstoedit : "),hb);
	tmp = new QLabel("dynamical",hb);
	tmp->setAlignment(Qt::AlignRight);

	// texvc
	hb = new QHBox(vbox);
	new QLabel(i18n("TeX support (texvc) : "),hb);
	tmp = new QLabel("dynamical",hb);
	tmp->setAlignment(Qt::AlignRight);

	// ImageMagick
	hb = new QHBox(vbox);
	new QLabel(i18n("ImageMagick : "),hb);
	st = "no";
#ifdef HAVE_MAGICK
	st = MagickLibVersionText;
#endif
	tmp = new QLabel(st,hb);
	tmp->setAlignment(Qt::AlignRight);

	// Jasper
	hb = new QHBox(vbox);
	new QLabel(i18n("JasPer library : "),hb);
	st = "no";
#ifdef HAVE_JASPER
	st = JAS_VERSION;
#endif
	tmp = new QLabel(st,hb);
	tmp->setAlignment(Qt::AlignRight);

	// liborigin
	hb = new QHBox(vbox);
	new QLabel(i18n("liborigin library : "),hb);
	st = LIBORIGIN_VERSION_STRING;
	tmp = new QLabel(st,hb);
	tmp->setAlignment(Qt::AlignRight);

	// qsa
	hb = new QHBox(vbox);
	new QLabel(i18n("Qt Script for Applications (QSA) : "),hb);
	st = "no";
#ifdef HAVE_QSA
	st = QSA_VERSION_STRING;
#endif
	tmp = new QLabel(st,hb);
	tmp->setAlignment(Qt::AlignRight);

	// CDF
	hb = new QHBox(vbox);
	new QLabel(i18n("Common Data Form library (CDF) : "),hb);
	st = "no";
#ifdef HAVE_CDF_CONFIG
	st = QString::number(CDF_LIBRARY_VERSION)+'.'+QString::number(CDF_LIBRARY_RELEASE)+'.'+
		QString::number(CDF_LIBRARY_INCREMENT);
#elif defined(HAVE_CDF)
	st = "yes";
#endif
	tmp = new QLabel(st,hb);
	tmp->setAlignment(Qt::AlignRight);

	// netCDF
	hb = new QHBox(vbox);
	new QLabel(i18n("netCDF : "),hb);
#ifdef HAVE_NETCDF
	tmp = new QLabel("yes",hb);
#else
	tmp = new QLabel("no",hb);
#endif
	tmp->setAlignment(Qt::AlignRight);

	// HDF5
	hb = new QHBox(vbox);
	new QLabel(i18n("HDF5 : "),hb);
#ifdef HAVE_HDF5
	st = QString::number(H5_VERS_MAJOR)+'.'+QString::number(H5_VERS_MINOR)+'.'+QString::number(H5_VERS_RELEASE);
	tmp = new QLabel(st,hb);
#else
	tmp = new QLabel("no",hb);
#endif
	tmp->setAlignment(Qt::AlignRight);

	// audiofile
	hb = new QHBox(vbox);
	new QLabel(i18n("audiofile library : "),hb);
	st = QString::number(LIBAUDIOFILE_MAJOR_VERSION)+'.'+QString::number(LIBAUDIOFILE_MINOR_VERSION);
#ifdef LIBAUDIOFILE_MICRO_VERSION
	st += '.'+QString::number(LIBAUDIOFILE_MICRO_VERSION);
#endif
	tmp = new QLabel(st,hb);
	tmp->setAlignment(Qt::AlignRight);

	// R
	hb = new QHBox(vbox);
	new QLabel(i18n("R library : "),hb);
	st = "no";
#ifdef HAVE_R
	st = QString(R_MAJOR)+'.'+QString(R_MINOR);
#endif
	tmp = new QLabel(st,hb);
	tmp->setAlignment(Qt::AlignRight);

	QObject::connect(ok,SIGNAL(clicked()),SLOT(accept()));
	apply->hide();
	save->hide();

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}
