//LabPlot : WorksheetDialog.h

#ifndef WORKSHEETDIALOG_H
#define WORKSHEETDIALOG_H

#include <qtoolbutton.h>
#include <qcolor.h>
#include <qcheckbox.h>
#include "Worksheet.h"
#include "Dialog.h"
#include "RichTextWidget.h"

class WorksheetDialog: public Dialog
{
	Q_OBJECT
public:
	WorksheetDialog(MainWin *mw, const char *name);
	void updateDialog();
public slots:
	void enableTitle(bool e=true) { enabletcb->setChecked(e); }
	bool TitleEnabled() { return enabletcb->isChecked(); }
	void setTitle(QString t) { titlele->setText(t); }
	QString Title() { return titlele->text(); }
	void setColor(QColor c) { bgcolor->setColor(c); }
	void setWorksheetColor(QColor c) { setColor(c); }
	QColor Color() { return bgcolor->color(); }
	QColor BackgroundColor() { return Color(); }
	QColor WorksheetColor() { return Color(); }
	void enableTimeStamp(bool e=true) { enablecb->setChecked(e); }
	bool TimeStampEnabled() { return enablecb->isChecked(); }
	void setTimeStamp(QString t) { timestample->setText(t); }
	QString TimeStamp() { return timestample->text(); }
	void setSize(int x, int y) { xni->setValue(x); yni->setValue(y); }
	void setWidth(int x) { xni->setValue(x); }
	void setHeight(int y) { yni->setValue(y); }
	Point Size() { return Point(xni->value(),yni->value()); }
	int Width() { return xni->value(); }
	int Heigth() { return yni->value(); }

	int Apply() { return apply_clicked(); }
	void updateTimeStamp();
private:
	KColorButton *bgcolor;
	KComboBox *wbrushcb;
	QCheckBox *enabletcb, *enablecb, *objectscb;
	KLineEdit *titlele, *timestample;
	KIntNumInput *xni, *yni;
	KPushButton *update;
private slots:
	void ok_clicked() {apply_clicked(); accept(); }
	void colorChanged();
	void saveSettings();
	int apply_clicked();
};

#endif //WORKSHEETDIALOG_H
