//LabPlot : SeasonalListDialog.h

#ifndef SEASONALLISTDIALOG_H
#define SEASONALLISTDIALOG_H

#include "ListDialog.h"

class SeasonalListDialog : public ListDialog
{
	Q_OBJECT
public:
	SeasonalListDialog(MainWin *mw, const char *name);
public slots:
	void setPeriod(int n) { nni->setValue(n); }		//!< set period for season
	void setNumber(int n) {setPeriod(n); }
	void setOperation(int o) { ocb->setCurrentItem(o); }		//!< set operation
	int Apply() { return apply_clicked(); }
private:
	KComboBox *ocb;
	KIntNumInput *nni;
private slots:
	void saveSettings();
	int apply_clicked();
};

#endif // SEASONALLISTDIALOG_H
