//LabPlot : Rect.cc

#include <math.h>
#include <iostream>
#include <kdebug.h>
#include "Rect.h"

using namespace std;

Rect::Rect(Point s,Point e,QColor c,int w, bool f, QColor fi) {
	start = s;
	end = e;
	color = c;
	width = w;
	filled = f;
	fillcolor = fi;
}

QStringList Rect::Info() {
	QStringList s;

	// no rect
	if(start.X() == end.X() && start.Y() == end.Y())
		return s;

	s << QString::number(start.X())+"/"+QString::number(start.Y());
	s << QString::number(end.X())+"/"+QString::number(end.Y());
	s << QString::number(width);
	s << color.name();
	s << QString::number(filled);
	s << fillcolor.name();

	return s;
}

// draw the line on the worksheet
void Rect::draw(QPainter *p, int X, int Y) {
//	kdDebug()<<"Rect::draw() from "<<X*start.X()<<'/'<<Y*start.Y()<<" to "<<X*end.X()<<'/'<<Y*end.Y()<<endl;

	if(fabs(end.X()-start.X())>1.0e-6) {
		p->setPen(QPen(color,width));

		if (filled)
			p->setBrush(fillcolor);
		else
			p->setBrush(Qt::NoBrush);

		p->drawRect((int)(X*start.X()),(int)(Y*start.Y()),(int)(X*end.X()),(int)(Y*end.Y()));
	}
}

// save
void Rect::save(QTextStream *t) {
	*t<<start.X()<<' '<<start.Y()<<' '<<end.X()<<' '<<end.Y()<<endl;
	*t<<color.name()<<' '<<width<<' '<<filled<<' '<<fillcolor.name()<<endl;
}

// open
void Rect::open(QTextStream *t,int) {
//	kdDebug()<<"Rect::open() : "<<version<<endl;
	double sx,sy,ex,ey;
	QString colorstring, fillstring;
	int f;

	*t>>sx>>sy>>ex>>ey;

	start.setPoint(sx,sy);
	end.setPoint(ex,ey);

	*t>>colorstring>>width>>f>>fillstring;
	color=QColor(colorstring);
	filled=(bool)f;
	fillcolor=QColor(fillstring);
}

QDomElement Rect::saveXML(QDomDocument doc) {
	QDomElement recttag = doc.createElement( "Rect" );

	QDomElement tag = doc.createElement( "Start" );
	tag.setAttribute("x",start.X());
	tag.setAttribute("y",start.Y());
    	recttag.appendChild( tag );
	tag = doc.createElement( "End" );
	tag.setAttribute("x",end.X());
	tag.setAttribute("y",end.Y());
    	recttag.appendChild( tag );
	tag = doc.createElement( "Color" );
    	recttag.appendChild( tag );
  	QDomText t = doc.createTextNode( color.name() );
    	tag.appendChild( t );
	tag = doc.createElement( "Width" );
    	recttag.appendChild( tag );
  	t = doc.createTextNode( QString::number(width) );
    	tag.appendChild( t );
	tag = doc.createElement( "Filled" );
    	recttag.appendChild( tag );
  	t = doc.createTextNode( QString::number(filled) );
    	tag.appendChild( t );
	tag = doc.createElement( "FillColor" );
    	recttag.appendChild( tag );
  	t = doc.createTextNode( fillcolor.name() );
    	tag.appendChild( t );

	return recttag;
}

void Rect::openXML(QDomNode node) {
	while(!node.isNull()) {
		QDomElement e = node.toElement();
		kdDebug()<<"RECT TAG = "<<e.tagName()<<endl;
		kdDebug()<<"RECT TEXT = "<<e.text()<<endl;

		if(e.tagName() == "Start")
			start.setPoint(e.attribute("x").toDouble(),e.attribute("y").toDouble());
		else if(e.tagName() == "End")
			end.setPoint(e.attribute("x").toDouble(),e.attribute("y").toDouble());
		else if(e.tagName() == "Color")
			color = QColor(e.text());
		else if(e.tagName() == "Width")
			width = e.text().toInt();
		else if(e.tagName() == "Filled")
			filled = (bool) e.text().toInt();
		else if(e.tagName() == "FillColor")
			fillcolor = QColor(e.text());

		node = node.nextSibling();
	}
}

bool Rect::inside(int x, int y, int w, int h) {
	double sx=start.X(), sy=start.Y();
	double ex=end.X(), ey=end.Y();
	if(x>sx*w && x<(ex+sx)*w && y>sy*h && y<(ey+sy)*h)
		return true;
	return false;
}
